<div class="contentWrapper">

    <div class="pageTitle overflow">
        <h1>
            <span>
                Conditions for alerts
            </span>
        </h1>
    </div>

    <div>
        <input type="text" placeholder="Search by condition name" ng-model="searchConds" style="vertical-align:top">
    </div>

    <div><?php $this->load->view('/partials/_notification'); ?></div>
    <div class="alert alert-warning" ng-show="filteredRules.length == 0">No conditions found</div>

    <div ng-show="filteredRules.length" class="row-fluid">
        <table class="table float-left margin-top table-horizontal" ng-show="rulesList.length >0">
            <thead>
            <th class="sort-head">
               <a ng-click="orderByField='name'; reverseSort = !reverseSort">
                    Name
                    <span ng-show="orderByField=='name'">
                        <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                        <i ng-show="reverseSort" class="icon-chevron-up"></i>
                    </span>
                </a>
            </th>
            <th class="sort-head">
               <a ng-click="orderByField='type'; reverseSort = !reverseSort">
                    Type
                    <span ng-show="orderByField=='type'">
                        <i ng-show="!reverseSort" class="icon-chevron-down"></i>
                        <i ng-show="reverseSort" class="icon-chevron-up"></i>
                    </span>
                </a>
            </th>
            <th>
                Description
            </th>
            <th>
                Details
            </th>
            <th>
                Actions
            </th>
            </thead>
            <tbody>
                <tr ng-repeat="rule in filteredRules = (rulesList | ruleSearchFilter:searchConds) | orderBy:orderByField:reverseSort">
                    <td class="no-wrap">{{rule.name}}</td>
                    <td>{{rule.type | DCA_ValueToString:'RuleTypes_dropDown' }}</td>
                    <td>{{rule.description}}</td>
                    <td>
                        <div class="muted" ng-switch on="rule.type">
                            <div ng-switch-when="policy">
                                <ul class="unstyled break-all">
                                    <li ng-show="rule.policyConditions.filterBy && rule.filterItemName">
                                        <span class="upper-first"><h5 class="inline">{{rule.policyConditions.filterBy}}:</h5></span> {{rule.policyConditions.filterItemName}}
                                    </li>
                                    <li ng-show="rule.policyConditions.promisehandle">
                                        <h5 class="inline">Promise handle:</h5> {{rule.policyConditions.promisehandle}}
                                    </li>
                                    <li>
                                        <h5 class="inline">Status:</h5> <span class="upper-first">{{convertStatus(rule.policyConditions.promiseoutcome)}}</span>
                                    </li>
                                </ul>
                            </div>

                            <div ng-switch-when="inventory">
                                 <ul class="unstyled break-all">
                                    <li ng-repeat="filter in rule.inventoryConditions.filters">
                                        <h5 class="inline">{{filter.label}}:</h5> {{filter.condition | FilterConditionLabel:filter}} <span ng-show="filter.type==='string'">'{{filter.value}}'</span><span ng-show="filter.type!=='string'">{{filter.value}}</span>
                                    </li>
                                </ul>
                            </div>

                           <div ng-switch-when="softwareupdate">
                               <ul class="unstyled break-all">
                                   <li>
                                       <b>Package name:</b> <span ng-if="rule.softwareUpdateConditions.patchname!=''">{{rule.softwareUpdateConditions.patchname}}</span><span ng-if="!rule.softwareUpdateConditions.patchname">All</span>
                                   </li>
                                   <li>
                                       <b>Architecture:</b> <span ng-if="rule.softwareUpdateConditions.patcharchitecture!=''">{{rule.softwareUpdateConditions.patcharchitecture}}</span><span ng-if="!rule.softwareUpdateConditions.patcharchitecture">All</span>
                                   </li>
                               </ul>
                            </div>
                        </div>
                    </td>
                    <td><a ng-click="deleteRule(rule.id,$index)" href="javascript:void(0)">remove</a></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="margin-bottom overflow-hidden">
        <ul class="nav pills token token-cyan">
            <li>
                <a ng-href="/dashboard/conditions/add">
                    <span><i class="icon-plus"></i></span><span>Create new condition</span>
                </a>
            </li>
        </ul>
    </div>
</div>
