<?php

/**
 * Class Data_transfer
 */
class Data_transfer extends Cf_Controller
{

    /**
     * Data_transfer constructor.
     */
    function __construct()
    {
        parent::__construct();
        setCurrentApplication('data_transfer');
    }

    /**
     * @rbacName View data transfer page
     * @rbacGroup Data transfer
     * @rbacAlias data_transfer.index
     * @rbacAllowedByDefault
     */
    function index()
    {
        $requiredcss = array(
            array('../../../themes/default/css/angularjs-ui/angular-ui.css'),
        );

        $this->carabiner->css($requiredcss);

        $bundles = array(
            array('dist/jquery-scripts.bundle.js'),
            array('dist/angular-base.bundle.js'),
        );

        $requiredjs = array(
            array('../themes/default/bootstrap/compiled/js/bootstrap.js'),
            array('data-transfer.jquery.js'),
            array('dataTransfer/app.js'),
            array('dataTransfer/controllers/dataTransferController.js'),
            array('dataTransfer/services/dataTransferService.js'),
            array('dataTransfer/directives/importUploader.js'),
        );

        $this->carabiner->js($bundles, $bundles, FALSE, FALSE);
        $this->carabiner->js($requiredjs, $requiredjs, TRUE, FALSE);

        $data = array('title' => 'Export / Import - Mission Portal');

        $this->template->load('template', 'data_transfer/index', $data);
    }


    /**
     * @param $partial
     */
    function partials($partial)
    {
        $view = 'partials/' . $partial . '.php';
        $this->load->view($view);
    }

}
