'use strict';

const sharedGroupController = baseGroupController.extend({
    init: function (
        $scope,
        $q,
        $routeParams,
        $modal,
        $cookies,
        sharedGroupsService,
        inventoryFilterService,
        inventoryDataService,
        inventoryService,
        inventoryHelper,
        commonHelper,
        paginationService
    ) {
        this._super(
            $scope,
            $q,
            $routeParams,
            $modal,
            $cookies,
            sharedGroupsService,
            inventoryFilterService,
            inventoryDataService,
            inventoryService,
            inventoryHelper,
            commonHelper,
            paginationService
        );

        this.$scope.shared = true;
        this.$scope.type = 'shared';
        this.$scope.tab = 'overview';
        this.$scope.makePersonal = this.makePersonal.bind(this);
    },

    defineListeners: function () {
        let self = this;

        this._super();
    },
    makePersonal: function () {
        common.globalSpinner.show();
        this.groupsService.makePersonal(this.$scope.groupId).then(
            response => {
                notify.success('Group made personal.');
                window.location.href = encodeURI(`/groups/personal/${response.data.id}`);
                common.globalSpinner.hide();
                this.$scope.personalgroup = true;
            },
            error => {
                notify.error(error.data);
                this.$scope.shared = true;
                common.globalSpinner.hide();
            }
        )
    }
});

sharedGroupController.$inject = [
    '$scope',
    '$q',
    '$routeParams',
    '$modal',
    '$cookies',
    'sharedGroupsService',
    'inventoryFilterService',
    'inventoryDataService',
    'inventoryService',
    'inventoryHelper',
    'commonHelper',
    'IEPaginationService'
];


const sharedGroupDataController = sharedGroupController.extend({
    init: function (
        $scope,
        $q,
        $routeParams,
        $modal,
        $cookies,
        sharedGroupsService,
        inventoryFilterService,
        inventoryDataService,
        inventoryService,
        inventoryHelper,
        commonHelper,
        paginationService
    ) {
        this._super(
            $scope,
            $q,
            $routeParams,
            $modal,
            $cookies,
            sharedGroupsService,
            inventoryFilterService,
            inventoryDataService,
            inventoryService,
            inventoryHelper,
            commonHelper,
            paginationService
        );

        this.$scope.tab = 'data';
    },
});

sharedGroupDataController.$inject = [
    '$scope',
    '$q',
    '$routeParams',
    '$modal',
    '$cookies',
    'sharedGroupsService',
    'inventoryFilterService',
    'inventoryDataService',
    'inventoryService',
    'inventoryHelper',
    'commonHelper',
    'IEPaginationService'
];
