<?php

$finder = PhpCsFixer\Finder::create()
    ->in(__DIR__)
    ->exclude([
        'system',
        'vendor',
        'node_modules',
        'public/scripts/node_modules',
    ])
    ->filter(fn (\SplFileInfo $file) => !preg_match('#/views(/|$)#', $file->getPath()))
;

return (new PhpCsFixer\Config())
    ->setRules([
        '@PSR12' => true,
        // Disable formatting rules that conflict with prettier
        'braces_position' => false,
        'single_line_empty_body' => false,
        'statement_indentation' => false,
        'indentation_type' => false,
        'line_ending' => false,
        'single_blank_line_at_eof' => false,
        'no_extra_blank_lines' => false,
        'blank_line_after_namespace' => false,
        'blank_line_after_opening_tag' => false,
        'method_chaining_indentation' => false,
        'array_indentation' => false,
        'function_declaration' => false,
        'curly_braces_position' => false,
        'control_structure_braces' => false,
        'control_structure_continuation_position' => false,
        'class_definition' => false,
        'no_alternative_syntax' => false,
        'elseif' => false,
        'no_multiline_whitespace_around_double_arrow' => false,
        'multiline_whitespace_before_semicolons' => false,
        'single_space_around_construct' => false,
        'no_multiple_statements_per_line' => false,
        // Keep code quality rules
        'array_syntax' => ['syntax' => 'short'],
        'single_quote' => true,
        'no_unused_imports' => true,
        'ordered_imports' => ['sort_algorithm' => 'alpha'],
    ])
    ->setFinder($finder)
    ->setRiskyAllowed(false)
;
