'use strict';

angular.module('actionHelperModule', [])
    .factory('actionHelper', ['$q', 'actionService',
        function ($q, actionService) {
            let helper = {};

            helper.triggerHubsAgentRun = function () {
                let deferred = $q.defer();

                actionService.getHubKey().then(function (result) {
                        if (result?.data?.key) {
                            actionService.agentRun(result.data.key).then(
                                () => setTimeout(deferred.resolve(), 1000),
                                error => deferred.reject(error)
                            )
                        }
                    },
                    () => deferred.reject());
                return deferred.promise;
            };

            return helper;
        }]
    );
