<?php

class ReportsExporter extends BaseDataExporter
{
    public function isOnlyForAdmin(): bool
    {
        return false;
    }

    public function getData(): array
    {
        $data = [];
        $this->db->reset_query();

        if ($this->exportOnlyUserItems == true || !$this->isAdmin) {
            $data['reports'] = $this->db->get_where('report', ['username' => $this->username])->result_array();
            $data['scheduled']['cfmp'] = $this->db
                ->get_where('report_schedule', ['userid' => $this->username])
                ->result_array();
            $data['scheduled']['cfsettings'] = $this->settingsDb
                ->get_where('scheduledreports', ['username' => $this->username])
                ->result_array();
        } else {
            $data['reports'] = $this->db->get('report')->result_array();
            $data['scheduled']['cfmp'] = $this->db->get('report_schedule')->result_array();
            $data['scheduled']['cfsettings'] = $this->settingsDb->get('scheduledreports')->result_array();
        }

        return [
            'info' => sizeof($data['reports']) . ', scheduled reports: ' . sizeof($data['scheduled']['cfmp']),
            'data' => json_encode($data),
        ];
    }
}
