<?php

readonly class AuditLogListArgumentsDto
{
    public function __construct(
        public int     $limit = 20,
        public int     $offset = 0,
        public string  $sort_column = AuditLogModel::DEFAULT_SORT_COLUMN,
        public string  $sort_direction = AuditLogModel::DEFAULT_SORT_DIRECTION,
        public ?string $actor = null,
        public ?string $objectType = null,
        public ?string $objectId = null,
        public ?string $objectName = null,
        public ?string $action = null,
        public ?int $created_after = null,
        public ?int $created_before = null,
    ) {

    }

    public static function fromArray(array $data)
    {
        return new self(
            $data['limit'] ?? 20,
            $data['offset'] ?? 0,
            $data['sort_column'] ?? AuditLogModel::DEFAULT_SORT_COLUMN,
            $data['sort_direction'] ?? AuditLogModel::DEFAULT_SORT_DIRECTION,
            $data['actor'] ?? null,
            $data['object_type'] ?? null,
            $data['object_id'] ?? null,
            $data['object_name'] ?? null,
            $data['action'] ?? null,
            isset($data['created_after']) ? intval($data['created_after']) : null,
            isset($data['created_before']) ? intval($data['created_before']) : null,
        );
    }
}
