<?php

class CF_Alert
{
    public $id;
    public $username;
    public $name;
    public $severity;
    public $ruleid; // reference to the rule

    public $widgetid; // reference to the widget
    public $widgetName; // name of widget alert attached too

    // status info
    public $lastStatusChange; // when alert change status from success to failure or vice versa  | timestamp
    public $lastCheck; // last run time | timestamp
    public $lastEventTime; // When event was created, used for reminder feature | timestamp
    public $status; // current alert status - success, fail, internal_error

    public $failHosts;
    public $totalHosts;

    public $pause; // numeric value or -1, which means that alert is paused indefinitely. Numeric value = time when alert was paused + timeout
    public $paused; // 1 or 0

    public $serverTime; // we need this to caclucate pause time

    public $emailToNotify; // array of references to the notifications
    public $reminder; // array of references to the notifications

    public $hostContextsProfileId; // reference to the host filter profile
    public $hostContextsPath; // reference to the nodes
    public $hostContexts; // object contain name and includes array - JSON string in DB
    public $excludedHosts; // object contain name and excludes array - JSON string in DB

    public $site_url;

    public function __construct($params = [])
    {
        // common properties
        $this->id = isset($params['id']) ? $params['id'] : null;
        $this->username = isset($params['username']) ? $params['username'] : null;
        $this->name = isset($params['name']) ? $params['name'] : null;
        $this->severity = isset($params['severity']) ? $params['severity'] : null;
        $this->ruleid = isset($params['ruleid']) ? $params['ruleid'] : null;

        $this->widgetid = isset($params['widgetid']) ? $params['widgetid'] : null;
        $this->widgetName = isset($params['widgetname']) ? $params['widgetname'] : null;

        // after first check
        $this->lastStatusChange = isset($params['laststatuschange']) ? (int) $params['laststatuschange'] : null;
        $this->lastCheck = isset($params['lastcheck']) ? (int) $params['lastcheck'] : null;
        $this->lastEventTime = isset($params['lasteventtime']) ? (int) $params['lasteventtime'] : null; // this is when last event was created, we need this for reminder feature
        $this->status = isset($params['status']) ? $params['status'] : null;

        // ALL alerts
        $this->failHosts = isset($params['failhosts']) ? $params['failhosts'] : 0;
        $this->totalHosts = isset($params['totalhosts']) ? $params['totalhosts'] : 0;

        //if paused
        $this->pause = isset($params['pause']) ? (int) $params['pause'] : null;
        $this->paused = isset($params['paused']) ? $params['paused'] : 0;

        $this->serverTime = time();

        $this->emailToNotify = isset($params['emailtonotify']) ? $params['emailtonotify'] : null;
        $this->reminder = isset($params['reminder']) ? (int) $params['reminder'] : null;

        $this->hostContextsProfileId = isset($params['hostcontextsprofileid'])
            ? $params['hostcontextsprofileid']
            : null;
        $this->hostContextsPath = isset($params['hostcontextspath']) ? $params['hostcontextspath'] : null;
        $this->hostContexts = isset($params['hostcontexts']) ? json_decode($params['hostcontexts'], true) : null;
        $this->excludedHosts = isset($params['excludedhosts']) ? json_decode($params['excludedhosts'], true) : null;

        $this->site_url = isset($params['site_url']) ? $params['site_url'] : null;
    }

    public function getId()
    {
        return $this->id;
    }

    public function getUsername()
    {
        return $this->username;
    }

    public function getName()
    {
        return $this->label;
    }

    public function getSeverity()
    {
        return $this->severity;
    }

    public function getRuleId()
    {
        return intval($this->ruleid);
    }

    public function getWidgetId()
    {
        return $this->widgetid;
    }

    public function getWidgetName()
    {
        return $this->widgetName;
    }

    public function getLastStatusChange()
    {
        return $this->lastStatusChange;
    }

    public function getLastCheck()
    {
        return $this->lastCheck;
    }

    public function getFailHosts()
    {
        return $this->failHosts;
    }

    public function getTotalHosts()
    {
        return $this->totalHosts;
    }

    public function getPaused()
    {
        return $this->paused;
    }

    public function getPause()
    {
        return $this->pause;
    }

    public function getEmailToNotify()
    {
        return $this->emailToNotify;
    }

    public function getReminder()
    {
        return $this->reminder;
    }

    public function getServerTime()
    {
        return $this->serverTime;
    }

    public function getHostContextsProfileId()
    {
        return $this->hostContextsProfileId;
    }

    public function getHostContextsPath()
    {
        return $this->hostContextsPath;
    }

    public function getHostContextsManual()
    {
        return $this->hostContextsManual;
    }

    public function getSiteUrl()
    {
        return $this->site_url;
    }
}
