<?php
class Widget extends Cf_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('widget_model');
        $this->load->model('dashboard_model');
    }

    public function savewidget()
    {
        $data = [];

        $id = $this->input->post('id'); // not mandatory
        if (!empty($id)) {
            $data['id'] = $id;
        }

        $payload = $this->input->post('payload') ? $this->input->post('payload') : '{}';
        $data['name'] = $this->input->post('name', true);
        $data['type'] = $this->input->post('type');
        $data['payload'] = is_array($payload) ? json_encode($payload) : $payload;
        $data['alerts'] = $this->input->post('alerts');
        $data['widgets'] = $this->getCurrentWidgets();
        $data['username'] = $this->session->userdata('username');
        $data['dashboardid'] = empty($this->input->post('dashboard'))
            ? $this->dashboard_model->get_user_selection(['username' => $data['username']])[0]['dashboard']
            : intval($this->input->post('dashboard'));
        $is_admin = $this->ion_auth->is_admin();

        $overwrite = false;
        if (!empty($data['id'])) {
            $overwrite = true;
        }

        try {
            $obj = $this->widget_model->savewidget($data, $overwrite, $is_admin);
        } catch (Exception $e) {
            $message = $e->getMessage();
            log_message('debug', 'Unable to save widget, error: ' . $message);
            respond_internal_error($message);
            return;
        }

        if (!isset($obj)) {
            //not able to get inserted rule
            $errors = $this->widget_model->getErrors();
            $data = json_encode($errors);
            respond_internal_error($data);
            return;
        } else {
            $data = [];
            $data[0] = [
                'widgetId' => $obj->id,
                'text' => $this->lang->line('dashboard_widget_save_success'),
                'errorCode' => 200,
            ];
            respond_ok(json_encode($data));
            return;
        }
    }

    public function deletewidget()
    {
        $widgetId = $this->input->post('widgetId', true);

        $filter['id'] = intval($widgetId);

        $is_admin = $this->ion_auth->is_admin();

        // QUICK FIX FOR PRESERVING OOTB WIDGETS
        if ($filter['id'] < 4) {
            respond_ok();
        } else {
            $filter['username'] = $this->session->userdata('username');

            try {
                $result = $this->widget_model->delete_widgets($filter, $is_admin);
                $json = json_encode($result);
                respond_ok($json);
            } catch (Exception $e) {
                $message = $e->getMessage();
                log_message('debug', 'Unable to delete widget, error: ' . $message);
                respond_internal_error($message);
            }
        }
    }

    /**
     * Return only widget info
     * example:
            "id": "52c22443fa463489063c986b",
               "username": "admin",
               "name": "widgetname",
               "type": "alert",
               "alerts": ['52b23646fa4634500d3c986b', '...',]
     *
     *
     * @param <string> $widgetId - record id
     */
    public function getwidgets($widgetId = '')
    {
        $dashboard = isset($_REQUEST['dashboard']) ? intval($_REQUEST['dashboard']) : null;

        //$this->output->enable_profiler(TRUE);
        $filter = [];
        $filter['widgets'] = $this->getCurrentWidgets($dashboard);

        if (!empty($widgetId)) {
            $filter['id'] = intval($widgetId);
        }

        try {
            $result = $this->widget_model->get_all_widgets($filter);

            if (empty($result)) {
                $message = $this->lang->line('dashboard_widget_not_exist');
                log_message('debug', 'Failed retrieving widgets, error: ' . $message);
                respond_internal_error($message);
                return;
            }

            $json = json_encode($result);
            respond_ok($json);
        } catch (Exception $e) {
            $message = $e->getMessage();
            log_message('debug', 'Failed retrieving widgets, error: ' . $message);
            respond_internal_error($message);
        }
    }

    /*
     * function to return only list of allowed widget ids, based on user's current selected dashboard
     *
     */
    public function getCurrentWidgets($dashboard = null)
    {
        $filter = [];
        $filter['username'] = $this->session->userdata('username');
        $user_dash = $dashboard ?? $this->dashboard_model->get_user_selection($filter)[0]['dashboard'];
        $filter = [];
        $filter['id'] = $user_dash;
        $widgetList = $this->dashboard_model->get_all_dashboards($filter);
        if (!empty($widgetList)) {
            return $widgetList[0]->getWidgets();
        }
    }

    /**
     * return widget with full information about alerts
     *
     *
     * @param <string> $widgetId - record id
     */
    public function getwidgetswithalerts($widgetId = '')
    {
        $filter = [];
        //$filter['username'] = $this->session->userdata('username');
        $filter['widgets'] = $this->getCurrentWidgets();

        if (!empty($widgetId)) {
            $filter['id'] = $widgetId;
        }

        try {
            $result = $this->widget_model->get_all_widgets($filter);
            $json = json_encode($result);
            respond_ok($json);
        } catch (Exception $e) {
            $message = $e->getMessage();
            log_message('debug', 'Failed retrieving widgets, error: ' . $message);
            respond_internal_error($message);
        }
    }

    public function reorderwidgets()
    {
        $username = $this->session->userdata('username');
        $data = $this->input->post('newOrder');

        if (empty($data)) {
            $message = 'Data with new order is empty';
            log_message('debug', 'reorderwidgets(): ' . $message);
            respond_internal_error($message);
        }

        if (empty($username)) {
            $message = 'Unable to find user';
            log_message('debug', 'reorderwidgets(): ' . $message);
            respond_internal_error($message);
        }

        try {
            $result = $this->widget_model->reorderwidgets($username, $data);
            $json = json_encode($result);
            respond_ok($json);
        } catch (Exception $e) {
            $message = $e->getMessage();
            log_message('debug', 'Unable to save new order, error: ' . $message);
            respond_internal_error($message);
        }
    }

    public function size()
    {
        $id = $this->input->post('id');
        if (is_int($id)) {
            respond_internal_error('Widget id is required');
            return;
        }

        try {
            $this->widget_model->updatePayload($id, ['size' => $this->input->post('size')]);
        } catch (Exception $e) {
            $message = $e->getMessage();
            log_message('debug', 'Unable to change widget size, error: ' . $message);
            respond_internal_error($message);
            return;
        }
    }
}
