<?php

namespace Controllers;

use models\SettingsModel;
use Slim\Container;
use Slim\Http\Request;

/**
 * Class SettingsController
 * @package Controllers
 */
class SettingsController extends ProtectedController
{
    /**
     * @var \models\ISettings
     */
    private $settingsModel;

    public function __construct(Container $container)
    {
        parent::__construct($container);

        $this->settingsModel = new SettingsModel($container);
    }

    /**
     * @param Request $request
     * @param $response
     * @param $args
     * @return mixed
     */
    public function getSettings(Request $request, $response, $args)
    {
        $data = [
            'success' => true,
            'data' => $this->settingsModel->getSettingsWithoutPassword(),
        ];
        $response = $response->withJson($data);
        return $response;
    }

    public function setSettings(Request $request, $response, $args)
    {
        $data = $request->getParsedBody();

        if (isset($data['make_backup']) && $data['make_backup'] == 'true') {
            $this->settingsModel->makeBackup();
        }

        // Set default values if admin_username, admin_password, or anonymous_bind are missing in the body data
        $data = array_merge(['admin_username' => '', 'admin_password' => '', 'anonymous_bind' => 'false'], $data);
        $isCredentialsSet = !empty($data['admin_username']) && !empty($data['admin_password']);

        if ($data['anonymous_bind'] === 'true') {
            if ($isCredentialsSet) {
                throw new \InvalidArgumentException(
                    'Admin username and password should not be provided if Anonymous bind is true',
                );
            }
        } elseif (!$isCredentialsSet) {
            throw new \InvalidArgumentException('Admin username and password are required if Anonymous bind is false');
        }
        $this->container->logger->debug('SettingsController::setSettings()', $data);

        if ($this->settingsModel->validate($data) && $this->settingsModel->update($data)) {
            $data = [
                'success' => true,
                'data' => 'Settings successfully saved.',
            ];
            $response = $response->withJson($data);
        }

        return $response;
    }
}
