<?php

class SharedGroupCmdbEntryFactory
{
    public static function fromRequest(object $data, string $group_id): SharedGroupCmdbEntry
    {
        $entries = $data->entries ?? [];

        $subentries = array_map(function ($subentry) use ($group_id): SharedGroupCmdbSubEntry {
            return new SharedGroupCmdbSubEntry(
                id: null,
                entry_id: null,
                group_id: $group_id,
                item_name: $subentry->item_name ?? '',
                item_type: $subentry->item_type ?? '',
                item_value: $subentry->item_value ?? '',
            );
        }, $entries);

        return new SharedGroupCmdbEntry(
            id: null,
            group_id: $group_id,
            name: $data->name ?? '',
            description: $data->description ?? '',
            tags: (array)($data->tags ?? new \stdClass()),
            type: $data->type ?? '',
            meta: (array)($data->meta ?? new \stdClass()),
            subentries: $subentries
        );
    }
}
