<?php
require_once APPPATH . 'modules/advancedreports/classes/ApiResponseInventoryDataDecorator.php';
require_once APPPATH . 'modules/advancedreports/classes/ApiResponseInventoryVariablesDecorator.php';

/**
 * Class InventoryAPIService
 */
class InventoryAPIService
{
    /** @var HttpClientInterface $restClient */
    private $restClient = null;

    public function __construct($restClient)
    {
        $this->restClient = $restClient;
    }

    /**
     * @return mixed|string
     * @throws Exception
     */
    public function getVariables()
    {
        $response = $this->restClient->get('/inventory/attributes-dictionary');
        $decorator = new ApiResponseInventoryVariablesDecorator($response);

        return $decorator->getProcessed();
    }

    /**
     * @param integer $id
     * @param array $data
     * @return mixed|string
     * @throws Exception
     */
    public function updateVariable($id, $data)
    {
        $response = $this->restClient->patch('/inventory/attributes-dictionary/' . $id, $data);
        $decorator = new ApiResponseInventoryVariablesDecorator($response);

        return $decorator->getProcessed();
    }

    /**
     * @param $params
     * @return mixed|string
     * @throws Exception
     */
    public function getData($params)
    {
        $response = $this->restClient->post('/inventory', $params);
        $decorator = new ApiResponseInventoryDataDecorator($response);

        return $decorator->getProcessed();
    }
}
