## 3.27.0
- Added AI chat agent for finding information about infrastructure (ENT-12993)
- Added php-fpm service management to sysvinit enterprise script
  (ENT-13234)
- Fixed issue with inventory report rows per page resetting on changing filters
  (ENT-13047)
- Fixed issue with Run Agent button and long-running policy causing timeouts (ENT-13291)
- The command `cf-hub --show-license` now shows the hub host key instead
  of the license checksum (ENT-8474)
- Adjusted host search to allow for MP using a custom port (ENT-13570)
- Changed behavior of tags when merging shared groups.
  Variables and classes defined by shared groups are now tagged with
  `shared_group=<GROUP_NAME>` to indicate where it originates from.
  Furthermore, tags are now only extended if the variable itself is
  extended. Otherwise the tags of a lower priority group is replaced by
  the tags of a higher priority group. (ENT-10448, ENT-11920)
- Fixed inability to delete host without reporting data (ENT-13654)
- Renamed changelog file to CHANGELOG.md (ENT-13497)

**Security fixes:**
- Fixed CVE-2026-24710 - Injection in mission portal:
  https://cfengine.com/blog/2026/cve-2026-24710-and-cve-2026-24711-and-cve-2026-24712/
- Fixed CVE-2026-24711 - Broken Access Control in Mission Portal:
  https://cfengine.com/blog/2026/cve-2026-24710-and-cve-2026-24711-and-cve-2026-24712/

**Packaging changes:**
- Added Debian 13 platform support (ENT-13164)
- Added RedHat 10 platform support (ENT-13016)
- Added symlinks to CFEngine binaries in `/usr/sbin` for RHEL packages
  (ENT-13008)
- Adjust hub packaging scripts in cases where no files are found during upgrade
  (ENT-13214)
- Adjusted compile-options to not bundle OpenSSL on newer SuSE systems due to libpam/openssl incompatability
  (ENT-12528)
- Adjusted detection of systemd in package scriptlets to handle more valid states
  (ENT-13277)
- Adjusted hub package for upcoming 3.27 release to migrate the database of previous versions
  (ENT-13266)
- Aligned Hub package perms for share/GUI on EL and Debian platforms with the MPF
  (ENT-13161)
- Changed suse-15 to use system openssl as redhats do (ENT-12528)
- Increased general timeout for Mission Portal httpd.conf to allow for slower hardware and longer agent runs
  (ENT-13291)

## 3.26.0
- Modified new hub install to use a setup code instead of hard-coded username/password.
- Added possibility to add non-cfbs/classic projects to CFEngine Build projects list (ENT-12097)
- Added count of deleted hosts to cf-support (ENT-12728)
- Added the field `hostkey` in hostwithclass that, when
  selected, returns a list of public key SHAs. (ENT-3032)
- Adjust handle duplicate hosts during federated import process to handle database schema changes
  (ENT-12946)
- Fixed bug in exception handling in handle duplicate hostkeys during import feature
  (ENT-12779)
- Fixed Changes report not preserving host filter (ENT-8904)

**Packaging changes:**
- Moved CFE_ROBOT user creation from MP cli task to shell script
  (ENT-12185)
- Removed redhat-6 from supported platforms as of 3.25.0 (ENT-12345)
- Added nghttp2 dependency in preparation for apache/php-fpm/http2
  (ENT-11440)
- Added SUSE 15+ to agent packages which have init scripts removed
  (CFE-4077)
- Added use of php-fpm and http2 for hub (ENT-11440)
- Fixed issue where rhel >8 packages would not have correct openssl
  dependency version (ENT-12587)

## 3.25.0
- Introduced "Forgot password" functionality to MP login screen (ENT-10837)
- Significantly improved performance of the duplicate hostnames health diagnostic report
  (ENT-12112)
- Password changes now invalidate all other logged in sessions (ENT-11945)
- Added the audit log functionality, including UI and API (ENT-11978)
- Added two-factor authentication to UI and API (ENT-10838)
- Added the option to pass token life time to the OAuth API
  (ENT-12055)
- Adjusted Mission Portal CMDB API to return 404 in case of no data for a host ID
  (ENT-12010)
- Fixed cf-hub shutdown behavior to silence warning about not owning a lock of type ShareLock
  (ENT-12385)
- Fixed memory corruption / segfaults in cf-serverd
  (ENT-12128, ENT-12145)
- Fixed issue where cf-hub perpetually logged that a host has checked in
  (once) after being deleted. Now it will never log more than once for
  each checkin. (ENT-11838)
- Fixed "Remember me" logic and adjusted the session time to last for one week
  (ENT-12055)

**Security fixes:**
- Fixed CVE-2024-55958 - Cross-site scripting (XSS) / missing input validation in
  CFEngine Enterprise Mission Portal. See the blog post for more information:
  https://cfengine.com/blog/2025/cve-2024-55958/

**Packaging changes:**
- Adjusted hub upgrade database migration to show only actionable logs
  (ENT-12383)
- Allowed images from raw.github.com for CFEngine Build module pages (ENT-12531)
- Fixed issues with long hostnames causing installation to fail - Modified the hub package
  install scriptlet to use hostname -s and fail if that is longer than 64 characters
  (CFE-4469)

## 3.24.0
- The value of the `CFEngine roles` attribute is now a string list with
  "Client" on an Enterprise client, and "Reporting hub" and "Policy server"
  on an Enterprise hub. See the change in behavior blog post for more info:
  https://cfengine.com/blog/2024/change-in-behavior-cfengine-roles/
- Duplicate tags are now removed for variables and classes
  in CMDB (host specific data  and group data) (ENT-11450)
- A group can now be used as the host filter in inventory reports and API (ENT-9982)
- Added the `Deleted hosts still reporting` health diagnostics report
  (ENT-8001)
- The user API now measures and enforces password complexity (ENT-10843)
- Adjusted masterfiles-stage.sh script to choose an available locale
  (ENT-11885)
- Allowed access for cfapache to read host_specific.json
  Allowed read access for cfapache to
  `$(sys.workdir)/cmdb/SHA=*/host_specific.json` through ACLs.
  (ENT-11809)
- Auxiliary data of Build projects are no longer stored under /root/.cfengine
  (ENT-11910)
- Changed OAuth API to allow users to see and revoke its own tokens
  (ENT-11892)
- Changed cf-support to collect all postgresql.log files (ENT-10899)
- Increased reset password length to 14 characters (ENT-10835)
- Made count of alerts triggered for specific host link to filtered report
  (ENT-11132)
- Mission Portal now defaults to perms 0600 when creating files
  (ENT-11197)
- The host info page now returns 404 when host not found or no access
  (ENT-11439)
- Moved scheduled reports from cf-hub to cf-reactor (ENT-8890)
- Periodic alert evaluation is now done by cf-reactor
  instead of runalerts.php (and the cf-runalerts service)
  (ENT-11538)
- Promise log data now includes meta tags of promises (ENT-4692)
- PromiseExecutions and PromiseLog tables now include
  promise meta tags (ENT-4692)
- Reset passwords now expire after 48 hours (ENT-10843)
- Reversed order of shared host groups data by priority (ENT-10386)
- Group names are now limited to 100 characters (ENT-11502)
- Sped up compliance report when using many checks (ENT-11442)
- cf-reactor now refreshes inventory variables (ENT-11763)
- Added RBAC permission to allow host deletion without access control checks
  (ENT-11205)
- Added API endpoints to permanently delete or restore previously deleted hosts
  (ENT-8001)
- Added CMDB suggestion item to disable recommendation log messages
  (ENT-11488)
- Added collection of running PostgreSQL settings to cf-support
  (ENT-11576)
- Added delays between unsuccessful authentication attempts (ENT-10845)
- Added documentation for __AgentStatus table (ENT-11567)
- Added functionality to see merged CMDB JSON on the host info page
  (ENT-11263)
- Added possibility to change password in the user profile section
  (ENT-10848)
- Fixed CMDB item data saved as an array instead of JSON object when empty body
  (ENT-11269)
- Fixed First/Last report timestamps in host info page not showing after some time
  (ENT-11886)
- Fixed LDAP login failures (ENT-11187)
- Fixed SQL typo involved in cf-hub setting call-collect flag
  (ENT-11204)
- Fixed bug where rebase report queries didn't flush empty tables
  (ENT-11906)
- Fixed cf-support hanging in case cf-serverd was not already running
  (ENT-10486)
- Fixed the check detail reports of compliance reports where multiple conditions on a
  single attribute resulted in duplicated columns for that attribute (ENT-11227)
- Fixed compliance report creation which failed to create more than 10 reports
- Fixed compliance report widget loading when all checks are failing
  (ENT-9920)
- Fixed inconsistency in events shown in dashboard event log (ENT-11471)
- Fixed dashboard exporter not fetching alert rules created by others
  (ENT-9100)
- Fixed a bug causing the decommissioned hosts widget opening a report when clicked (ENT-11888)
- Fixed inventoried policy release id when masterfiles-stage deploys with cfbs
  (ENT-10832)
- Fixed cases where host filter in inventory reports did not return hosts when
  negative operators are used with not-reported variables (ENT-11443)
- Fixed issue causing custom notification scripts to be lost during CFEngine upgrades
  (ENT-11340)
- Fixed issues which caused unnecessary page reloads in Mission Portal (ENT-10372)
- Fixed an issue with requests to refresh oauth tokens not granting new refresh tokens
  (ENT-11521)
- Fixed a bug causing software installed and software updates reports to break after editing
  (ENT-11933)
- Fixed a bug with whitespace in user roles (ENT-11276)
- Fixed the `Collect reports every minute` CMDB suggestion (ENT-11518)

**Packaging changes:**
- /usr/local/sbin/cfbs now exists as a symlink
  to /var/cfengine/bin/cfbs making `sudo cfbs` work in
  environments where /usr/local/sbin is in sudo secure_path
  (ENT-10936)
- Package installation now aborts if backup directory exists and is non-empty
  (ENT-11233)
- Adjusted calling pg_upgrade during upgrade to include
  LD_LIBRARY_PATH of previous installation (ENT-11853)
- Adjusted cfbs packaging on rhel-8 to use platform-python (ENT-11338)
- Excluded content and file time for runalerts.php from rpm verification
  (ENT-11094)
- Marked httpd.conf as a configuration file in RPMs (ENT-11094)
- Need libssl-dev for systemssl build hosts (ENT-11166)
- Postinstallation scriptlets of hub packages now use
  reflinks to copy masterfiles and web UI files if
  possible
- Removed /etc/init.d/cfengine3 from EL9+ packages (ENT-11901)
- Set RPM verification of postgresql.log to not consider time and
  content hash (ENT-11094)
- Squashed common errors logged by Apache related to IPv6 (ENT-10646)
- Updated apache from 2.4.58 to 2.4.59
- Updated git from 2.42.1 to 2.45.2
- Updated libacl from 2.3.1 to 2.3.2
- Updated libattr from 2.5.1 to 2.5.2
- Updated libcurl from 8.4.0 to 8.8.0
- Updated libxml2 from 2.11.5 to 2.13.1
- Updated lmdb from 0.9.31 to 0.9.33
- Updated openldap from 2.6.6 to 2.6.8
- Updated openssl from 3.1.4 to 3.3.1
- Updated pcre2 from 10.42 to 10.44
- Updated php from 8.2.12 to 8.3.8
- Updated postgresql from 15.5 to 16.3
- Updated rsync from 3.2.7 to 3.3.0
- Updated zlib from 1.3 to 1.3.1

## 3.23.0
- Added cleanup of shared host groups data on deletion or when a shared group is made personal
  (ENT-10417)
- Added collection of information from pg_stat_activity to cf-support
  (ENT-10730)
- The UI now remembers the chosen number of groups per page (ENT-10368)
- Adjusted ldap queries to include only login_attribute and group_attribute instead of default-set
  (ENT-10408)
- Clarified what "handle" means in comment for __monitoringmgmeta.observable
  (ENT-10393)
- Disabled groups app in case of no inventory (ENT-10461)
- Fixed Inventory API failure when there is a colon in the class filter value
  (ENT-10389)
- Fixed groups class filters having dots when they should have underscores
  (ENT-10377)
- Fixed modal include/exclude hosts pagination (ENT-10380)
- Fixed pagination bug in include/exclude by hostkey (ENT-10380)
- Fixed paginator to handle more than 5 pages (ENT-10380)
- Fixed syntax highlighting/colors in policy analyzer (ENT-10650)
- Improved locale override in masterfiles stage scripts (ENT-10753)
- Improved performance of software update alert SQL query for large tables
  (ENT-10752)
- Now using the raw value of vars in inventory reports (ENT-4277)
- Added simplistic IP-address classes on Windows (ENT-2044)
- Renamed hostsFilter Inventory API parameter to hostFilter (ENT-10363)
- Implemented hosts including/excluding by inventory attributes (ENT-9959)
- Guarded against invalid input syntax for type numeric during federated
  reporting import process (ENT-10906)
- Fixed potential deadlock between cf-reactor single host inventory update
  and federated reporting import process (ENT-10906)
- Fixed federated reporting schema lock not operating properly (ENT-10906)
- Added anonymous bind option for LDAP Authentication Settings (ENT-10403)

**Security fixes:**
- Fixed CVE-2023-45684 - Mission Portal SQL injection vulnerability.
  See the blog post for more information: https://cfengine.com/blog/2023/cve-2023-45684/

**Packaging changes:**
- Added better handling of postgresql server state during hub package install
  (ENT-10647)
- Fixed and improved postgresql server state handling in package scriptlets
  (ENT-10647)
- Fixed issue with using pg_upgrade on ubuntu-16 hub installer upgrade
  (ENT-10710)
- Guarded against race condition in install scriptlets with restorecon
  (ENT-10429)
- Improved locale env vars safety during installation for postgresql
  (ENT-10739)
- Updated apache from 2.4.57 to 2.4.58
- Updated git from 2.41.0 to 2.42.1
- Updated libcurl from 8.1.2 to 8.4.0
- Updated libcurl-hub from 8.1.2 to 8.4.0
- Updated libxml2 from 2.11.4 to 2.11.5
- Updated lmdb from 0.9.30 to 0.9.31
- Updated openldap from 2.6.4 to 2.6.6
- Updated openssl from 3.1.1 to 3.1.4
- Updated php from 8.2.7 to 8.2.12
- Updated postgresql from 15.3 to 15.5
- Updated zlib from 1.2.13 to 1.3

## 3.22.0
- Added host groups application (ENT-9482)
- Added host groups API (ENT-9772)
- Added shared host groups CMDB API (ENT-9483)
- Added additional host inventory API filter and context filters
  applied directly to the query (ENT-9773)
- Added database comments for __monitoringmgmeta and __monitoringmg
  table columns (ENT-9796)
- Added possibility to set OR condition in the Inventory API filters
  (ENT-8916)
- Added support of string module input type in the MP UI (ENT-9854)
- Changed various widgets to a more appropriate graph type, line
  graphs(ENT-9522)
- Changed style of not reported pinned items on host info page
  (ENT-9589)
- Denied custom PostgreSQL functions execution except for authorized
  ones (ENT-9826)
- Disabled LDAP functions on macOS platform (ENT-9871, ENT-9878)
- Fixed class finder input search in Firefox
  (ENT-10244)
- Fixed compliance by category chart config changing on export
  (ENT-9522)
- Fixed host info page ignoring URL parameter and opening host from the
  saved cookie (ENT-10232)
- Fixed refreshing host specific measurement page takes to the host
  info page (ENT-9792)
- Hostname now links to host info page instead of the same target as
  "View report" button in the alert status table (ENT-10272)
- Implemented new modal based UI for adding columns in inventory report
  (ENT-9481)
- Improved speed of update_inventory procedure to avoid empty FR dumps
  (ENT-10214)
- Replaced old gifs and images in Mission Portal (ENT-8580)
- The child process of cf-hub that is responsible for running
  scheduled reports now connects to the DB as the cfapache user and thus
  with limited access (ENT-9825)
- Updated dark mode welcome tour images (ENT-9913)

**Security fixes:**
- Fixed CVE-2023-26560 - Unauthorized access to system files through
  scheduled reports. See the blog post for more information:
  https://cfengine.com/blog/2023/cve-2023-26560/

**Packaging changes:**
- Added cfengine-enterprise SELinux module source files and instructions
  (ENT-9685)
- Added rpm requires for selinux-policy version we build with
  (ENT-9685)
- Updated Apache from 2.4.54 to 2.4.57
- Updated apr from 1.7.0 to 1.7.4
- Updated apr-util from 1.6.1 to 1.6.3
- Updated diffutils from 3.8 to 3.10
- Updated git from 2.38.1 to 2.41.0
- Updated libcurl from 7.86.0 to 8.1.2
- Updated libcurl-hub from 7.86.0 to 8.1.2
- Updated libxml2 from 2.10.3 to 2.11.4
- Updated lmdb from 0.9.29 to 0.9.30
- Updated openldap from 2.6.3 to 2.6.4
- Updated openssl from 3.0.7 to 3.1.1
- Updated php from 8.1.12 to 8.2.7
- Updated postgresql from 15.1 to 15.3

## 3.21.0
- Added Build API call to check if a project is synchronised with VCS settings
  (ENT-9666)
- Added Build module input UI and API (ENT-8927)
- Added a newline to the end of API responses body (ENT-9355)
- Added cf-enterprise-support script to be sourced by cf-support
  (ENT-9037)
- Added editable fields component to dashboard and compliance report titles
  (ENT-9449)
- Added favicon (ENT-7728)
- Added functionality to delete Build projects (ENT-9015)
- Added libpq notice receiver to redirect notices to logger (ENT-3966)
- Added options for lower frequency reminders down to 1 minute (ENT-3599)
- Added possibility to deploy Build projects locally (ENT-8972)
- Added possibility to send base64 encoded modules names to the Build API
  (ENT-9345)
- Added weekly reminder intervals up to 4 weeks (ENT-9510)
- Adjusted reports page styles (ENT-9016)
- Allowed multiple Build local projects creation (ENT-9460)
- Allowed to insert JSON array into CMBD variable data container
  (ENT-9635)
- Build modules are now shown as external when they are added from URL or local files
  (ENT-9345)
- Changed compliance score calculation logic (ENT-8923)
- Changed host info page content (ENT-8392)
- Changed owner of OTTB reports to CFE_ROBOT (ENT-8260)
- Changed owner of out-of-the-box reports from admin to CFE_ROBOT system user
  (ENT-8260)
- Changed verified registry settings from info to verbose log level
  (ENT-9575)
- Do not include LDAP groups in Mission portal users roles (ENT-9588)
- Empty string as the rbac.filter value no longer causes
  NOTICE messages in PostgreSQL logs (ENT-8253)
- Enabled compliance report importing if an inventory attribute is not reported
  (ENT-9023)
- Filtered out software available updates which intersect with installed software versions
  (ENT-9632)
- Fixed Build API updating is_empty (ENT-8977)
- Fixed Build API not returning 404 status when a module is not found
- Fixed Build module deletion request without the request body
- Fixed cases where update button was not displayed for Build in MP (ENT-9538)
- Fixed changes report displaying encoded special chars (ENT-9542)
- Fixed compliance report importing when long list of conditions
  (ENT-9089)
- Fixed creating dashboard rules with long names or descriptions
  (ENT-9089)
- Fixed dismissed health diagnostic hosts list when no limit or offset passed
  (ENT-9532)
- Fixed edit user empty dialog when a role has edit user permission
  (ENT-9475)
- Fixed external Build modules removing and displaying in the added modules list
  (ENT-9345)
- Fixed git_cfbs_deploy_refspec in masterfiles_stage leaving temp dir
  (ENT-9039)
- Fixed multi-alert widget destroyed if navigate to alternate dashboard while attaching conditons
  (ENT-9591)
- Fixed viewing or editing roles by users who have corresponding RBAC permissions
  (ENT-9639)
- Implemented new UI for exporting compliance reports (ENT-9138)
- Implemented possibility to create multiple Build projects (ENT-9015)
- Improved UI for displaying LDAP users and roles (ENT-9588)
- Moved ldap_log to application directory where it belongs (ENT-9693)
- Moved log messages for windows services about already being in desired state from info to verbose
  (ENT-9569)
- Processes promises now log verbose instead of info when not sending signals on windows
  (ENT-9574)
- Removed `Failed checks by severity` compliance widget (ENT-8922)
- Removed resize and full screen widgets buttons (ENT-8914)
- Renamed HA status top menu to Hub and extended with hub information
  (ENT-9610)
- Renamed health diagnostics to be more user friendly (ENT-9523)
- Replaced badly scaled dark mode Build logo in Build in MP (ENT-8974)
- Replaced the badly scaled Build logo (ENT-8974)
- Replaced the compliance widget image with lighter background.
  (ENT-9404)
- Views applying RBAC can now be used even in DB
  sessions where rbac.filter is not set in which case it
  is considered to be empty (no filtering) (ENT-9637)
- 404 status code is now returned when a page is not found (ENT-8559)

**Packaging changes:**
- Add Debian 11 aarch64 labels (ENT-8978)
- Added cf-support binary to packages (ENT-9037)
- Added Ubuntu 22 hub and agent packages (ENT-8479)
- Installer will now skip removing cfengine-enterprise SELinux module if
  not installed (ENT-9594)
- Updated Apache from 2.4.53 to 2.4.54
- Updated Git from 2.36.1 to 2.38.1
- Updated libcurl from 7.83.1 to 7.86.0
- Updated libiconv from 1.17 to 1.17
- Updated libxml2 from 2.10.3 to 2.9.1
- Updated OpenLDAP from 2.6.2 to 2.6.3
- Updated OpenSSL from 3.0.4 to 3.0.7
- Updated PHP from 8.1.7 to 8.1.12
- Updated PostgreSQL from 14.3 to 15.1
- Updated rsync from 3.2.4 to 3.2.7
- Updated SASL2 from 2.1.27 to 2.1.28
- Updated zlib from 1.2.12 to 1.2.13

## 3.20.0
- Mission Portal now has a new CFEngine Build application. This application
  allows you to combine multiple modules from build.cfengine.com into 1 project
  and subsequently deploy this project as a policy set on your hub.
- Added compliance reports widget (ENT-8081)
- Various parts of the UI was improved, especially dark mode and reports interfaces
- Fixed export of ootb compliance reports
- Compliance checks without a report are no longer imported (ENT-8259)
- The import/export user interface now shows the settings menu on the left (ENT-8044)
- CFEngine now runs cf-reactor, an event reaction daemon (ENT-7357)
- Inventory refresh requests are now handled by cf-reactor not cf-hub
  (ENT-8307)
- Host specific data in the __cmdb table is now deleted on host deletion (ENT-8570)
- Fixed problems related to empty / NULL values in CMDB data
  (ENT-8406)
- Added validation to exclude CFEngine variables from CMDB values
  (ENT-7468)
- Fixed `Inventory attribute not found` error while compliance report importing
  (ENT-8480)
- Fixed false positive report email sending status (ENT-8046)
- "info: New hosts discovered..." is no longer falsely reported by cf-hub
  (ENT-8422)
- Made Meta tags field available for classes and variables in Report Builder
  (ENT-790, ENT-5568)
- Made PromiseLog table available in Report Builder (ENT-7290)
- Added comments on __PromiseLog table (ENT-8267)
- Added comments for __contexts and __contextslog PostgreSQL tables
  (ENT-8389)
- Adjusted cfdb schema to allow upgrades (ENT-7505)
- An agent run is now triggered when FR hub state is changed (ENT-7965)
- Reduced exclusive lock time during FR import (ENT-8727)
- Feeder's data is now removed on feeder deletion (ENT-7970)

**Packaging changes:**
- `cfbs` is now part of enterprise hub packages on
  platforms with Python 3.5 or newer (ENT-8439)
- Enterprise hub packages now pull python3 as a (weak) dependency
  (ENT-8439)
- Improved check for `ss` command on newer debian distros (ENT-8293)
- Stopped loading unused Apache modules by default on Enterprise Hubs:
  mod_actions (ENT-8503), mod_asis (ENT-8505), mod_auth_digest
  (ENT-8608), mod_authn_anon (ENT-8600), mod_authn_dbd (ENT-8601),
  mod_authn_dbm (ENT-8599), mod_authn_file (ENT-8598), mod_authnz_ldap
  (ENT-8512), mod_authz_groupfile (ENT-8603), mod_authz_user
  (ENT-8604), mod_autoindex (ENT-8514), mod_deflate (ENT-8523),
  mod_dumpio (ENT-8526), mod_env (ENT-8522), mod_expires (ENT-8610),
  mod_filter (ENT-8524), mod_include (ENT-8507), mod_ldap (ENT-8509),
  mod_log_forensic (ENT-8501), mod_mime_magic (ENT-8517),
  mod_negotiation (ENT-8511), mod_reqtimeout (ENT-8525), mod_spelling
  (ENT-8499), mod_unique_id (ENT-8519), mod_usertrack (ENT-8521),
  mod_version (ENT-8497), mod_vhost_alias (ENT-8513), substitute
  (ENT-8498), mod_info (ENT-8504), mod_status (ENT-8506), mod_webdav (ENT-8495)
- Dropped support for CentOS 6 HUB package
- Updated git from 2.34.1 to 2.36.1
- Updated rsync from 3.2.3 to 3.2.4
- Updated libcurl from 7.80.0 to 7.83.1
- Updated openldap from 2.6.0 to 2.6.2
- Updated apache from 2.4.51 to 2.4.53
- Updated php from 8.0.12 to 8.1.7
- Updated openssl from 1.1.1l to 3.0.4
- Updated libiconv from 1.16 to 1.17
- Updated postgresql from 13.5 to 14.3

## 3.19.0
- Added API to get deleted hosts list (ENT-7469)
- Added constraint disallowing empty strings for hostkey in __hosts
  (ENT-8003)
- Added hover state to outline buttons (ENT-7399)
- Added import/export compliance reports possibility (ENT-6470)
- Added inventoryFile parameter to the Hosts by class API (ENT-7664)
- Added vcs type dropdown the Version control repository settings
  (ENT-7710)
- Added vcs type parameter to the VCS API (ENT-7710)
- Adjusted PDF reports (ENT-7690)
- Adjusted host info page styles (ENT-7429)
- Changed NOTICE to DEBUG in cfdb schema.sql where appropriate to reduce noise
  (ENT-3742)
- Changed Policy Deployment Alert to target hosts reporting policy_server
  (ENT-3607)
- Changed UI toasts styles (ENT-7455)
- Changed dark mode logo (ENT-7398)
- Changed images for adding new widgets (ENT-7604)
- Changed inventory condition explanations (ENT-7655)
- Changed modal dialogs styles (ENT-7509)
- Changed reports temporary directory (ENT-7465)
- Changed widgets colors in dark mode (ENT-7351)
- Check group checkbox when all permissions inside are checked on RBAC settings page
  (ENT-7229)
- Copied masterfiles-stage CFBS changes from core (ENT-7709, ENT-7891)
- Fixed Advanced Report filters SQL building (ENT-7520)
- Fixed CMDB array textarea wrong value when losing focus with an empty value
  (ENT-7930)
- Fixed adding multiple feeders in a row (ENT-7964)
- Fixed adding multiple inventory widgets for the same attribute to a dashboard
  (ENT-7298)
- Fixed issue with cli_tasks not working when HTTPS_PROXY env var set
  (ENT-7732)
- Fixed links in compliance PDF reports (ENT-7366)
- Fixed links in compliance PDF reports (ENT-7366)
- Fixed tooltip indicating default bundle for CMDB variables was main instead of variables
  (ENT-7421)
- Fixed troubleshooting guidance for host never collected from
  (ENT-7499)
- Fixed typo in received entries from diagnostics table (ENT-7522)
- Fixed up monitoring data on nodes (ENT-7353)
- Fixed wrong time in changes reports (ENT-7912)
- Fixed wrong widget alerts in a newly created dashboard with default widgets
  (ENT-7949)
- Host selection and prioritization for report collection is now deterministic
  (ENT-5271)
- Improved compliance form UX (ENT-7437)
- Missing software version no longer causes patch failures in reporting
  (ENT-7419)
- Provided overwrite option in the User management setting when a user exists
  (ENT-681)
- Replaced URLs with links in reports tables (ENT-7694)
- Set JS and CSS cache permissions to 0440 (ENT-7261)
- Showed IPv4 addresses from inventory on the Hub management (ENT-7232)
- Sorted variables and classes alphabetically on the host info page
  (ENT-7369)
- Trigger an agent run after enabling of the Policy analyzer or Federated reporting
  (ENT-7335)
- Use advisory lock for Federated Reporting deadlock avoidance
  (ENT-7474)
- Use advisory lock for Federated Reporting schema changes (ENT-7474)

**Security fixes:**
- Fixed CVE-2021-44215 - PostgreSQL log file world readable.
  See our blog post for more information:
  https://cfengine.com/blog/2022/cve-2021-44215-and-cve-2021-44216/
- Fixed CVE-2021-44216 - Apache and Mission Portal Application log files world readable
  See our blog post for more information:
  https://cfengine.com/blog/2022/cve-2021-44215-and-cve-2021-44216/

**Packaging changes:**
- Changed 4th octet in Windows package version to match package release number
  (ENT-7554)
- Enforced permissions for Postgres log (ENT-7961)
- Moved httpd.pid to root of httpd workdir (ENT-7966)
- VCS configuration now works on RHEL 8 hubs (ENT-7898)
- Updated pcre from 8.44 to 8.45
- Updated openssl from 1.1.1k to 1.1.1l
- Updated diffutils from 3.7 to 3.8
- Updated openldap from 2.5.5 to 2.6.0
- Updated libcurl-hub from 7.77.0 to 7.80.0
- Updated git from 2.32.0 to 2.34.1
- Updated postgresql from 13.3 to 13.5
- Updated libcurl from 7.77.0 to 7.80.0
- Updated apache from 2.4.48 to 2.4.51
- Updated php from 8.0.7 to 8.1.0


## 3.18.0
- Added API to trigger agent run (ENT-6180)
- Added CMDB API (ENT-6785)
- Added Health diagnostics condition for multiple identities
  reporting same host identifier (ENT-6653)
- Added breadcrumbs to compliance check reports (ENT-6462)
- Added categorization for inventory attributes
  This change introduces two new inventory attributes:
  - `Allowed users for cf-runagent`
  - `Allowed hosts for cf-runagent`
  Two other inventory attributes have been renamed:
  - `Kernel`, previously referred to as `OS type`
  - `Kernel Release`, previously referred to as `OS kernel`
  Note: Old agents will continue to report under the old names.
  (ENT-6742)
- Added confirmation window when closing unsaved forms (ENT-6492)
- Added database table for hosts-specific CMDB data (ENT-6784)
- Added default pin items to users profiles (ENT-6550)
- Added description to compliance check tooltip (ENT-6461)
- Added hostkey and OS columns to Software Updates alert report
  (ENT-6545)
- Added new column to all hosts compliance check report which
  tells if a host is passing or failing (ENT-6741)
- Added save button when editing compliance report title (ENT-6458)
- Added the button to trigger an agent run from the Host info page
  (ENT-6180)
- Changed compliance report URN from `/reports/compliance_report`
  to `/reports/compliance-report`(ENT-6891)
- Changed host specific software installed/available reports (ENT-6771)
- Changed redirect after host delete to dashboard (ENT-6427)
- Changed reports endpoint URL from `/advancedreports#/` to `/reports/`
  (ENT-6514)
- Cleared session storage before opening inventory report from the
  host info page to avoid loading previous report (ENT-6467)
- Errors when reading cookie values from LMDB no longer cause
  "Hosts likely using the same identity" false positives (ENT-6476)
- Fixed JS errors after clicking alerts widgets (ENT-6547)
- Fixed dark theme charts on exported PDF reports (ENT-6739)
- Fixed error when navigating back to a report from edit (ENT-6546)
- Fixed issue causing report collection failures (ENT-6525)
- Fixed plpgsql error in pgschema.sql pin_items_to_existing_users
  (ENT-6797)
- Fixed sys.release for Windows Server 2019 (ENT-4496)
- Greyed out items from dropdown after placing into inventory report
  (ENT-6581)
- Hide graphical elements of inventory chart widgets when there
  are no data (ENT-6526)
- Implemented new style of MP header, nav bar and tables (ENT-7085)
- Improved UX of regex validation (ENT-6453)
- Moved host info page buttons to the title section (ENT-7053)
- Ordered categories and compliance checks alphabetically (ENT-6493)
- Organized inventory/classes/variables on the host info page
  (ENT-6496)
- Removed IP address from title when zooming in on measurement
  graphs (ENT-6515)
- Removed index.php from URL (ENT-6464)
- Send localhost address when triggering agent run on the hub
  (ENT-7091)
- Show host filter in compliance check tooltip (ENT-6738)
- cf-hub: Added --ignore-preferred-augments command line option
  (CFE-3656)
- Added restart service policy option for Windows (ENT-4643)

**Security fixes:**
- Fixed CVE-2021-38379 - Publicly available exported reports.
  See our blog post for more information:
  https://cfengine.com/blog/2021/cve-2021-38379-and-cve-2021-36756/
- Fixed CVE-2021-36756 - Certificate not checked in Federated Reporting.
  See our blog post for more information:
  https://cfengine.com/blog/2021/cve-2021-38379-and-cve-2021-36756/

**Packaging changes:**
- Added redirect to remove index.php from Mission Portal's URL
  (ENT-6464)
- Do not apply redirect from index.php to internal APIs (ENT-6464)
- Enabled sockets in PHP config (ENT-6180)
- Fixed broken redirect from http to htttps (ENT-7039)
- Removed unused plugins directory (CFE-3518)
- Updated libxml2 from 2.9.10 to 2.9.12
- Updated openldap from 2.4.58 to 2.5.5
- Updated libcurl-hub from 7.75.0 to 7.77.0
- Updated apache from 2.4.46 to 2.4.48
- Updated git from 2.31.1 to 2.32.0
- Updated postgresql from 13.2 to 13.3
- Updated php from 8.0.3 to 8.0.7
- Updated libcurl from 7.75.0 to 7.77.0

## 3.17.0
- Added button and API to trigger report collection for a host
  (ENT-6179)
- Added dark mode to Mission Portal (ENT-6099)
- Added copy-to-clipboard buttons in Mission Portal (ENT-5044)
- You can now pin inventory, variables, and classes to the host info page
  (ENT-5571)
- Mission portal roles can now be automatically synced using LDAP,
  for example with Active Directory roles/tags.(ENT-6151)
- Added `is reported` and `is not reported` inventory filter conditions
  (ENT-6190)
- Added an ansible-compatible Hosts API endpoint to get hosts grouped by class (ENT-6175)
- Added an open report button to inventory widgets (ENT-6143)
- Inventory widgets now open filtered reports when clicking items (ENT-6972)
- Added regex support to Inventory API, filters and conditions (ENT-6057)
- Hosts with reporting issues are now highlighted in other reports (ENT-6228)
- Inventory attribute lists are now ordered by name (ENT-6456)
- Reports now indicate whether a variable is empty or not reported (ENT-6159)
- Query API now preserves null and empty string values from database (ENT-6159)
- Added function to remove duplicate hosts (disabled by default) (ENT-6035)
- There were several usability improvements to compliance reports UI.
  Compliance reports are now easier to navigate, more intuitive to edit,
  and provide a lot more useful information about checks and hosts. (ENT-6047)
- Added links to view Passing/Failing/All hosts in compliance reports
  (ENT-6137)
- Compliance checks can now be edited (ENT-6135)
- Custom compliance check categories can now be added (ENT-6114)
- Added tooltips describing Inventory conditions (ENT-6187)
- Total host count in compliance reports now respect host filter (ENT-6054)
- Fixed an issue causing `host bootstrapped at` to be unavailable (ENT-6112)
- Fixed `Change data type` styles to fit in small elements (ENT-6185)
- Fixed `JSON.parse: unexpected character at line 1` JS error (ENT-6052)
- Fixed `can't access property 0` JS error on a host page (ENT-6056)
- Fixed `hosts never collected from` report by excluding deleted hosts
  (ENT-6415)
- Fixed `remember me` option on the login page and set inactivity time
  before the next login will be required to 72 hours. (ENT-6106)
- Fixed classes modal window overlapping (ENT-6094)
- Fixed error in a browser console when clicking on inventory widget
  (ENT-6141)
- Fixed inventory report columns adding when an empty filter has applied
  (ENT-6499)
- Fixed issue where nova_cookies.lmdb wasn't closed for new hosts
  (ENT-6434)
- Fixed a memory corruption/crash when dealing with secondary groups in
  user promises on windows (ENT-6223)
- Fixed toggle button positioning in Firefox (ENT-6145)
- Fixed issue causing windows user promises to always repair (ENT-6223, ENT-6379)
- Fixed issue when trying to scroll to part 2 of legend in widgets (ENT-6378)

**Packaging changes:**
- Use /etc/os-release when detecting latest suse (ENT-5363)
- Build packages specific for SUSE/SLES 11,12,15 (ENT-5335, ENT-5363)
- Added diffutils 3.7 as vendored dependency (ENT-6373)
- RHEL 8 is now a supported platform for CFEngine hubs (ENT-6103)
- Updated lmdb from 0.9.24 to 0.9.27
- Updated openssl from 1.1.1g to 1.1.1h
- Updated openldap from 2.4.53 to 2.4.56
- Updated git from 2.28.0 to 2.29.2
- Updated postgresql from 12.4 to 13.1
- Updated php from 7.4.10 to 7.4.12
- Updated libcurl from 7.72.0 to 7.73.0

## 3.16.0
- Added compliance reports
  Compliance reports allow you to implement custom, high level,
  reports based on your compliance framework, requirements
  or regulation (ENT-5559)
- `cf-hub --query` now triggers inventory refresh for the given hosts
  (ENT-4864)
- Added CFEngine role information to the Host info page (ENT-5215)
- Added IP address column to `Hosts never collected from` health
  diagnostic report (ENT-3936)
- Added IPAddress column to __hosts table (ENT-5268)
- Added ON_ERROR_STOP true to catch SQL errors earlier (ENT-5115)
- Added OOTB inventory attributes for CFEngine Enterprise License
  (ENT-5089)
- Added `created by` column to shared dashboard list (ENT-5229)
- Added detailed hosts count information (ENT-4783)
- Added error message when attempting to collect from a deleted host
  (ENT-4247)
- Added fullscreen mode for widgets (ENT-5381)
- Added information to show when scheduled reports will be sent in
  local time (ENT-5285)
- Added inventory table widget to dashboard (ENT-5379)
- Added logic to handle bad status/__status table situations (ENT-5396)
- Added management of account expiration for Windows user promises
  (ENT-3116)
- Added missing tables to clear_hosts_references() (ENT-5399)
- Added possibility to always use browser time in Mission Portal
  (ENT-5310)
- Added possibility to change timezone in user profile (ENT-5214)
- Added possibility to clone shared dashboards (ENT-5232)
- Added possibility to grant access to see non-reporting hosts
- Added possibility to share dashboards with specific users or roles
  (ENT-5231)
- Added reminder about exceeded license limit in Mission Portal
  (ENT-5082)
- Added time_zone property to Users API (ENT-4067)
- Added warning when user with no assigned role uses Mission Portal
  (ENT-4651)
- Allowed to create dashboard with not unique name if someone already
  used this name (ENT-5320)
- Changed postgresql connection hostname to use a unix-domain socket
  by default (ENT-2747)
- Deleted hosts are now excluded from report collection
  Host delete is intended to be used for decommissioned hosts, so
  this should not be a problem. If you need a host to reappear,
  generate a new keypair and bootstrap it, as if it was a new host.
  (ENT-4247)
- Deleted hosts now appear in __hosts table with a deletion time stamp
  (ENT-4247)
- Dropped deprecated __PromiseExecutionsLog database table (ENT-5170)
- Fixed HTML special characters displaying in Changes report (ENT-5417)
- Fixed ProfileModel session usage in tests or CLI
- Fixed a crash in cf-hub while applying reporting data (ENT-4409)
- Fixed an issue with the client_history_timeout in cf-hub (ENT-4409)
- Fixed deselecting Hub Id column in the Query builder when editing a
  reports (ENT-5200)
- Fixed grammar in UI for creating condition based on file change
  (ENT-5414)
- Fixed health diagnostics API parameters validation. Using sent
  parameters instead of default.
- Fixed host search in Mission Portal which was returning "500 -
  Internal Server Error" (ENT-5250)
- Fixed inventory report scheduling when applying filter to a
  report. (ENT-5167)
- Fixed license info in Mission Portal when multiple rows in __hub table
  (ENT-5556)
- Fixed crash (segmentation fault) when cf-hub shuts down
- Fixed timing issues causing "patch failure" errors in reporting
  (ENT-4409)
- Hosts deletions are now completed more quickly/frequently (ENT-5092)
- Hosts which have not reported yet may now show up in __hosts table
  with LastReportTimestamp = NULL (ENT-5267)
- Inventory attribute list on widget adding was improved: added search
  box, attribute list was alphabetized and grouped by category.
  (ENT-5365)
- Inventory is now refreshed faster for call-collected hosts (ENT-4864)
- Inventory is now refreshed for newly bootstrapped hosts (ENT-4864)
- Inventory is now refreshed right after report collection (ENT-4864)
- Reduced false positives in `Last agent run unsuccessful` health check
  (ENT-4774)
- Removed application/logs/index.html (ENT-5255)
- Renamed old `Compliance` report category to `Promise outcomes` (ENT-5557)
- __hosts table now has IP address information (ENT-5268)
- cf-hub --show-license now has exit code 0 for free-25 (ENT-5297)
- cf-hub no longer prints many verbose log message for query timeout
- cf-hub: Fixed potential buffer overflow when parsing monitoring data

**Packaging changes:**
- `systemctl enable` failure no longer stops the postinstall package
  scripts (ENT-5188)
- Added checks for database state to avoid error messages during install
  (ENT-5115)
- Enabled mbstring PHP extension
- Made Mission Portal application log relocation more resilient
  (ENT-5255)
- RHEL 8 CFEngine packages now rely on system OpenSSL libraries
  (ENT-5564)
- Tighten Postgresql access permissions (ENT-2747)
  - Removed executable bit from unix socket
  - Removed local TCP access rules
- Added OS specification to deb filenames (ENT-5306)
- Added OS specification to rpm filenames (ENT-5306)
- Added OS specification to solaris filenames (ENT-5306)
- All secrets are now stored in secrets.ini file (ENT-5369)
- Updated openssl from 1.1.1f to 1.1.1g
- Updated libyaml from 0.2.2 to 0.2.5
- Updated openldap from 2.4.49 to 2.4.50
- Updated libcurl-hub from 7.68.0 to 7.70.0
- Updated apache from 2.4.41 to 2.4.43
- Updated git from 2.25.1 to 2.27.0
- Updated postgresql from 12.2 to 12.3
- Updated php from 7.4.2 to 7.4.6
- Updated libcurl from 7.68.0 to 7.70.0

## 3.15.0
- Added settings page to customize Mission Portal. Available options:
  Color schema, logo, additional text on the login page. (ENT-4914)
- cf-hub can now detect when multiple hosts are using the same hostkey
  This is done using the new cookie protocol. Randomized cookies
  are exchanged during each report collection, and if there is a
  mismatch with the previous cookie, it will show up as alerts in
  Mission Portal. The health indicator "Hosts likely using the same
  identity" is now using this system. The previous duplicate host
  detection system was done entirely in Database and had more false
  positives.
- Admins can now delete hosts which are missing reporting data (ENT-4942)
- Hosts that have not reported yet are no longer filtered out when RBAC
  is disabled (ENT-4712)
- Added --show-license option to cf-hub
  This option prints the license information in a structured
  and easy to read way. (ENT-4971)
- Hub now properly logs an error if license counts are exceeded
  (ENT-5080)
- cf-hub query report collection timeout is now customizable
  --query-timeout command line option, and query_timeout
  constraint in body hub control can be used to customize the
  timeout. Previously it was a hardcoded 30 seconds. (ENT-3153)
- Made cf-hub more robust against clients reporting bad timestamps
  (ENT-5056)
- Empty host names in `cf-hub --query -H` are now skipped (ENT-4866)
- Removed unnecessary line endings in reporting protocol. These showed up
  as `#012#015` and `#015` in logs (escaped), and caused confusion.
  (ENT-4777)
- Added average agent execution interval to the host info page
  (ENT-4543)
- Added average agent execution time for each policy entry to the Host
  info page (ENT-4542)
- Added classes and variables to the Host info page (ENT-3095)
- Added first report collection time to the host info page (ENT-4540)
- Added host bootstrapped at time to the host info page (ENT-4541)
- Added last agent execution time  to the host info page (ENT-4539)
- Added possibility to see inventory attributes and values on the host
  info page (ENT-710)
- Added report collection methodology to the host info page (ENT-4537)
- Added API call to get changed file list (ENT-3316)
- Added possibility to filter by inventory attributes in Query API
  (ENT-4321)
- Password entry fields in Mission Portal are now obscured by default,
  with a button to show password if necessary (ENT-5111)
- Added File integrity monitoring report (ENT-3316)
- Policy analyzer summary table grouped by promises execution frequency
  (ENT-4320)
- Added hosts and inventory filters to Policy analyzer (ENT-4321)
- Added possibility to select JOIN type in Query builder (ENT-4908)
- Added scroll to dropdown inventory attributes list (ENT-5074)
- Renamed Monitoring to Measurements
  The Monitoring module in Mission Portal is really data from measurement
  type promises. Monitoring brings to mind alerting, which we handle as a
  subset of our Dashboards. This name change clarifies the content.
  (ENT-5023)
- Changed session lock to allow parallel HTTP requests. Previously, the
  session library would create a lock and not allow new requests until
  the current one is not finished. This lock was introduced to avoid
  data overwriting when two or more parallel requests are writing into
  the same session variable, but this doesn't happen in our code
  (ENT-4860)
- Changed response codes in User API from 204 No Content to 202 Accepted
  for update and delete requests (ENT-4803)
- Deleted __LastSeenHostsLogs internal table and references (ENT-5052)
- Added usernames to apache access logs (ENT-5138)
- Reworked status table renaming to be more effective (ENT-4968)
- Added 10 minutes threshold to "Agent not run recently" health
  diagnostics category to avoid showing false positive warnings in case
  of manual cf-agent execution (ENT-4228)
- File changed alerts condition was added (ENT-4811)
- File changes statistics API was added (ENT-4727)
- File changes widget was added (ENT-4731)
- New indexes were added to __promiselog and __promiseexecutions tables
- Only read operations are now allowed via the query API (ENT-4938)
- Optimized Query API by adding limit directly to a user query
  (ENT-4903)
- Replaced promise_outcome type with character varying on
  __PromiseExecutions table to speed up select queries from
  PromiseExecutions view. Otherwise will be used sequence scan instead
  of index scan (ENT-4825)
- View to select not kept not repaired hosts was added (ENT-4862)
- Widget to show the total number of promises not kept and not repaired
  was added (ENT-4767)
- `Promises not kept (failed) that have not been kept or repaired`
  report was added (ENT-4766)
- Partitioned __inventory table for federated reporting (ENT-4842)
- Fixed Event log date range filter default values
  Now correctly shows current date, instead of 1 week in the past.
  (ENT-5072)
- Fixed email notification link to pause, edit or remove alerts
  (ENT-4249)
- Fixed file changes PDF report.  Used " escape parameter instead of
  default /  while CSV data parsing. Otherwise extra columns will be
  added. (ENT-4989)
- Fixed help indicator UI bug (ENT-4819)
- Fixed license owner to not show html characters (ENT-5024)
- Fixed missing public namespace for some PL/pgSQL functions (ENT-5040)
- Fixed incorrect Hub management UI "flashing" before being replaced by
  javascript (ENT-4787)
- Fixed `matches` inventory filter condition when list had only 1 item
  (ENT-5151)
- Fixed global search result active app. Change active application to
  hosts in case of global search result (ENT-4818)
- Fixed number of remaining days on license in header (ENT-4941)
- Fixed memory leak in windows version of glob matching (ENT-4895)
- Fixed small memory leak in cf-serverd, when packing enterprise
  reporting data (ENT-4895)
- Fixed potential memory leaks in nova API (ENT-4895)

**Security fixes:**
- Fixed CVE-2019-19394 - Mission Portal JavaScript injection vulnerability.
  See our blog post for more information:
  https://cfengine.com/blog/2020/cve-2019-19394-mission-portal-javascript-injection-vulnerability/

**Packaging changes:**
- Added ON_ERROR_STOP=1 to psql commands to make postinstall easier to
  debug (ENT-5035)
- Built packages now include mdb_load and mdb_copy lmdb utilities
  (CFE-3133)
- Added proper release number to BFF (ENT-4691)
- Addressed CVE-2019-1552 on Windows (ENT-4901)
- Publish tarball with a filesystem image and accompanying files for
  CoreOS (ENT-4758)
- Enabled zlib extension in PHP to support png images with alpha channel
  (ENT-2828)
- Fixed OOTB https redirection when hostname contains uppercase letters
  (ENT-4821)
- Wait for postgresql to be available before rotating keys (ENT-4853)
- `systemctl enable` failure no longer stops the postinstall package
  scripts (ENT-5188)
- Added build number to CoreOS and generic tarballs (ENT-4981)
- Added explicit build numbers to Windows, Solaris and HP-UX builds
  (INF-1253)
- state/pg directory permissions are now updated on on every upgrade
  (ENT-5063)
- Got rid of git commands and other DC legacy in postinstall script
  (ENT-4904)
- Fixed SQL schema error during upgrade (ENT-4835)
- Updated lmdb from 0.9.23 to 0.9.24
- Updated openssl from 1.1.1b to 1.1.1d
- Updated openldap from 2.4.47 to 2.4.48
- Updated apache from 2.4.39 to 2.4.41
- Updated git from 2.21.0 to 2.24.0
- Updated postgresql from 11.3 to 12.1
- Updated php from 7.3.5 to 7.4.0
- Updated libcurl from 7.64.1 to 7.67.0

## 3.14.0
- Added Federated Reporting APIs (ENT-4379)
- Added Health diagnostic API (ENT-4444)
- Added SQL queries to change saved reports (ENT-4093)
- Added data transfer module that allows to transfer Mission portal
  data between hubs (ENT-4126)
- Added decommissioned hosts widget to dashboard (ENT-4603)
- Added hostname to host page header (ENT-4620)
- Added log messages to the Policy analyser summary table (ENT-4323)
- Added missing slash in async query result URL (ENT-4553)
- Added new `is` match condition to software update alerts (ENT-569)
- Added new widgets to default dashboard after upgrade (ENT-4301)
- Added newline to API error responses (ENT-4747)
- Added not kept badge count to Policy analyzer app (ENT-4275)
- Added possibility to dismiss hosts from Health diagnostic reports
  (ENT-3950)
- Added web role-based access control and RBAC API (ENT-4139)
- Aligned host info and default saved reports for software updates available
  (ENT-4726)
- Aligned host info software report columns with stock software report
  (ENT-4726)
- Inventory API now allows multiple values for one filter (ENT-4371)
- Made permissions of CFE_ROBOT user more strict (ENT-4513)
- Changed clear_hosts_references to delete lastseenhosts based on hostkey
- Changed columns type from integer to biginteger for existing tables
  (ENT-4350)
- Changed hosts include/exclude requests to POST (ENT-4636)
- Changed m_host to vm_hosts in API to avoid querying to the protected materialized view
- Changed m_inventory into a regular table (ENT-4554)
- Changed policy analyzer hosts source from vm_hosts to hosts (ENT-4740)
- Changed trigger on insert into __hosts from EACH STATEMENT to EACH ROW
  (ENT-4662)
- Changed trigger to refresh m_hosts from EACH ROW to EACH STATEMENT
  (ENT-4443)
- Check processFilters function argument (ENT-4634)
- Clarified error message when report collection data is invalid
  (ENT-4495)
- Deny using materialized view over QUERY API (ENT-4477)
- Disable database triggers in the data generator (ENT-4662)
- Discover new hosts for report collection every minute (ENT-3844)
- Do not generate rbac_role_permission for cf_remoteagent role
  (ENT-4139)
- Do not wrap hostname in anchor HTML tag (ENT-4216)
- Expanded remote hub API with statistics data (ENT-4771)
- Extended status API to return hub info (ENT-4567)
- Fixed Host API deletion status codes (ENT-4265)
- Fixed detection of recent Windows versions (ENT-3363)
- Fixed edit sub-category dialog title (ENT-791)
- Fixed empty `Hosts never collected from` health diagnostic report (ENT-4696)
- Fixed errors in cf-serverd when loading old JSON promise log (ENT-4555)
- Fixed hanging reports with no errors in logs (ENT-4397)
- Fixed host tree loading issue (ENT-4214)
- Fixed host tree to show hosts when the uncategorized view is selected (ENT-4461)
- Fixed JS error on scheduled reports (ENT-4638)
- Fixed JSON content in the policy analyzer editor (ENT-4279)
- Fixed Policy analyzer filter by directory/file (ENT-4405)
- Fixed REST API basic authentication (ENT-4349)
- Fixed broken ootb_import.sql (ENT-4303)
- Fixed date extraction from table name in promise_log_partition_cleanup postgresql function
  (ENT-4588)
- Fixed duplicate key value violates unique constraint variables_dictionary_attribute_name
  (ENT-4342)
- Fixed inventory API limit in case of NULL value (ENT-4585)
- Fixed inventory widget empty and duplicate values (ENT-4464)
- Fixed license expiration in Mission Portal (ENT-4385)
- Fixed wrong file owner of generated scheduled reports (ENT-4600)
- Fixed 2 small memory leaks in enterprise agent (ENT-4313)
- Fixed a segmentation fault in parsing of reporting data
  If csv files in /var/cfengine/state/ (generated by agent runs)
  were corrupted, cf-serverd would crash while reading them. (ENT-4505)
- Fixed an issue with error handling in cf-hub delta queries
  cf-hub will now attempt a rebase if it cannot obtain the
  last report timestamp. This change only affects scheduled
  runs, not when invoked with `--query delta` from command
  line. This also means that hosts which are not present in
  status table will be rebased (not delta from 0). (ENT-4319)
- Fixed an issue with manual cf-hub delta queries
  When invoked manually (cf-hub --query delta) it would request
  the wrong starting timestamp from client, causing patch failures. (ENT-4120)
- Fixed edge case memory leak in enterprise agent/server (ENT-4313)
- Fixed memory leaks in cf-hub (ENT-4313)
- Fixed small memory leak in enterprise hub / agent (ENT-4313)
- Fixed small memory leak when using HA (ENT-4586)
- Fixed JS Errors in policy analyzer app (ENT-4799)
- Implemented web role-based access control (ENT-4139)
- Improved readability of reporting information on host info page
  (ENT-4531)
- Made it possible to edit software available and installed reports and add new filters to them
  (ENT-4278)
- Moved Health diagnostics from Mission portal to API (ENT-4444)
- Prevented segmentation fault in enterprise API when LicenseInfo is empty
  (ENT-4376)
- Relaced refresh materialized inventory view function by update_inventory
  (ENT-4554)
- Removed xss_clean validation rule from LDAP settings form because it prevents saving specific characters
  (ENT-4654)
- Renamed "IP Naming" to "Report Collection" (ENT-4471)
- Renamed the "Status" table to "__Status" with RBAC-checked view
  (ENT-4331)
- Renamed Host count widget to Newly bootstrapped hosts (ENT-4649)
- Simplified error handling and error messages for failed report collection
  (ENT-4495)
- Switched perms of various temporary files in state to 0600
  These files were created with 0644 permissions, and then
  repaired in policy. However, since they are deleted / recreated
  periodically, it causes INFO noise. Safer and better user
  experience to create them with restricted permissions to
  begin with.
  Affected files:
  * `$(sys.statedir)/context.cache.tmp`
  * `$(sys.statedir)/variable.cache.tmp`
  * `$(sys.statedir)/diff/*.diff`
  * `$(sys.statedir)/previous_state/*.cache`
  (ENT-4601)
- Updated links to postgresql docs to match running version (ENT-4436)
- Updated role database entry on POST requests instead of deletion and creation
  This change was made to avoid deleting related to role entries because previously while role updating the database entry is deleted and recreated.
  (ENT-4483)
- HTTPS protocol is now used in CLI commands (ENT-4361)
- Fixed license count for hosts with duplicate entries in lastseen DB
  (ENT-4595)
- Variable values can no longer be NULL in reporting
  The reporting system doesn't distinguish between NULL
  and empty string. Previously, variables with value
  "" would show up in psql as NULL. This can be
  cumbersome when writing queries, and doesn't
  accurately reflect the variable value in policy.
  NULLs are now converted to empty string before
  insert. This change only affects 2 tables in
  postgresql: "variables" and "variableslog".
  This change can trigger a rebase if you already
  have reporting data with variablevalue=NULL.
  (ENT-4093)
- cf-hub now validates that variable types are within range (ENT-4507)

**Security fixes:**
- Fixed CVE-2019-9929 - Internal authentication secrets leaked in logs.
  See our blog post for more information:
  https://cfengine.com/blog/2019/cve-2019-9929-internal-authentication-secrets-leaked-in-logs/

**Packaging changes:**
- Added ubuntu 18 to the list of build platforms (ENT-4041)
- Clean php extensions directory before install (ENT-2614)
- Disable phar read only (ENT-4126)
- Do not check for absence of postgresql directory before migration
  (ENT-4557)
- Fixed patterns not to include square brackets (ENT-4515)
- Fixed running cfengine3 init script in AIX RPMs (ENT-4305)
- Rewrote PostgreSQL migration (ENT-4353)
- Set -e in package scriptlets (ENT-3385)
- Set explicit permissions on the install log file (ENT-4506)
- Updated dependency table (ENT-4227)
- Password operations are now hidden from the install log (ENT-4512)
- Internal keys are now rotated on every upgrade (ENT-4515)
- Updated lcov from 1.13 to 1.14
- Updated lmdb from 0.9.22 to 0.9.23
- Updated pcre from 8.42 to 8.43
- Updated sasl2 from 2.1.26 to 2.1.27
- Updated libiconv from 1.15 to 1.16
- Updated libxml2 from 2.9.8 to 2.9.9
- Updated libyaml from 0.2.1 to 0.2.2
- Updated openldap from 2.4.46 to 2.4.47
- Updated libcurl-hub from 7.61.1 to 7.64.1
- Updated apr from 1.6.5 to 1.7.0
- Updated apache from 2.4.35 to 2.4.39
- Updated postgresql-hub from 11.0 to 11.3
- Updated php from 7.2.11 to 7.3.5
- Updated libcurl from 7.61.1 to 7.64.1
- Updated OpenSSL from 1.1.1 to 1.1.1b
- Updated git from 2.19.1 to 2.21.0
- Upgraded CodeIgniter from 3.1.3 to 3.1.10 (ENT-4486)

## 3.13.0
- Make class inventory available via inventory API (ENT-3885)
- Add custom SQL condition info to the Help page. (ENT-3821)
- Add line number to the promise execution log (ENT-3925)
- Add the policy file hash to the promise execution log (ENT-3996)
- Added an error summary when running cf-hub --query
- Allow to deselect default role. (ENT-3854)
- Change default limit of inventory widgets. (ENT-3875)
- Change design center data processing. (ENT-3818)
- Change/policy url format was changed (ENT-3895)
- Changed exit codes of cf-hub to be much more useful
  In short, when using --query, exit code will be number of failed
  host report collections, up to 100. 101+ are reserved for specific
  error conditions. See documentation for full details.
  Ticket: (ENT-3829)
- Fixed issue when Changes report sometimes was shown empty. (ENT-3894)
- Clean up grammar in bootstrap tour (ENT-3912)
- Clear hosts references in case of host was deleted. (ENT-3902)
- Group hosts without category into a "hosts without category" category
  in a hosts tree (ENT-3877)
- Export with several order by expressions was fixed. (ENT-3943)
- Fixed array encoding in Pest methods. (ENT-3818)
- Fixed different order in exported reports. (ENT-3982)
- Fixed error message on host tree when a user does not have any role.
  (ENT-3901)
- Fixed inventory filter value cannot be changed after clicking close button.
  (ENT-3919)
- Fixed waiting for element in selenium CustomAlertCondtionTest
  (ENT-3874)
- Fixed wrong hosts are using the same identity diagnostic reports.
  (ENT-3876)
- Handle unauthorized XHR requests. (ENT-3992)
- Hide edit user possibility for external users. (ENT-3940)
- Link to host page was added in Inventory report. (ENT-516)
- Method to define the default inventory filter condition was fixed.
  (ENT-3911)
- New type of report was added to identify hosts likely using same identity.
  (ENT-3550)
- Parsing of Changes/policy exclude and include parameters were changed.
  (ENT-3895)
- Pause/Resume tour guide  possibility was added (ENT-3867)
- Refresh materialized view in case of a host was bootstrapped.
  (ENT-3748)
- Removed wrong code that produces warnings from cli_tasks. (ENT-3928)
- Removing a user confirmation text was changed. (ENT-3643)
- Report Hosts never collected from was added to health diagnostics
  (ENT-3551)
- Report Hosts never collected from was added to health diagnostics
  (ENT-3551)
- Report Several hosts likely using same identity (ENT-3550)
- Fixed issue with exporting big (2-5M records) reports by running export
  by parts (ENT-3870)
- Set sendmail protocol selected by default. (ENT-3815)
- Show apply, cancel, clear buttons on reports with filter. (ENT-3881)
- Show ldap users into internal users tab. (ENT-3909)
- Show license reminder when licenseGranted more than 25. (ENT-3653)
- Silenced error about row number in error_log (ENT-3565)
- The SQL query to get hosts information was fixed. (ENT-3900)
- Tour guide about what's new in Mission Portal (ENT-3853)
- Validation improvements on LDAP settings. (ENT-3816)
- adjust enterprise code for atexit to cleanup refactoring (ENT-3756)
- Fixed host count group by in Firefox (ENT-3893)
- refine data_generator documentation (ENT-3887)

**Packaging changes:**
- Make runalerts.php executable. (ENT-3921)
- Moved old shared/GUI files aside during upgrade (ENT-3898)
- Set right owner and permissions to httpd/htdocs. (ENT-3906)
- Treat php.ini as a config file by pacakge (ENT-3835)
- Updated PHP from 7.2.6 to 7.2.11
- Upgraded PostgreSQL from 10.4 to 11.0
- Updated git from 2.17.0 to 2.19.1
- Updated Apache from 2.4.33 to 2.4.35
- Updated APR from 1.6.3 to 1.6.5
- Upgraded CURL from 7.59.0 to 7.61.0
- Upgraded libacl from 2.2.52 to 2.2.53
- Updated libattr from 2.4.47 to 2.4.48
- Upgraded YAML from 0.1.7 to 0.2.1
- Upgraded OpenSSL to 1.1.1

## 3.12.0
- Get cmdline info about all processes at once on windows (ENT-2536)
- Redis database and cf-consumer are no longer used
  All reports are applied to postgres from cf-hub worker threads.
  Logging and measurements have been updated to reflect this change.
  Reporting statuses (success, failure, rebase, retry) are no longer
  duplicated in these two databases. All statuses are stored and read
  from postgres
  The diagnostics measurement redis_processing_time_per_host has been
  replaced by hub_processing_time_per_host, tracking the time
  hub uses to apply reports to postgres (excluding time spent
  collecting report from client) (ENT-2814)
- Added ability to exclude specific hosts from dashboard alert conditions
  (ENT-3491)
- Added the option to skip mailing scheduled reports if 0 records added
  (ENT-3584)
- System V init now notifies when it skips managing postgres because of HA
  (ENT-3657)
- Inventory charts were added to dashboard (ENT-3234)
- Custom SQL-based condition type was added (ENT-3553)
- Removed old LDAP implementation
  /api/settings only supports ldapHost(ldapApiUrl) and ldapEnabled(ldap or
  internal) now. All other settings are managed with /ldap/settings API.
  (ENT-3247)
- Mail settings were added into Settings and Welcome tour parts
- Warn when attempting to delete missing *.diff file during serving rebase
  query by cf-serverd (ENT-3261)
- Ensured that runalerts.php is shutdown when using sysvinit (ENT-3310)
- Categorization view sharing in the hosts app fixed (ENT-3110)
- Add default alert for failed policy deployment (ENT-3436)
- Increased auto-increment limits for __PromiseLog, __MonitoringMgMeta,
  __MonitoringYrMeta tables (ENT-3404)
- Add b-tree index for variable value - improving inventory and variable
  table equality and `like` lookup performance (ENT-3393)
- Improved loading of monitoring app (ENT-3232)
- Reordered --help output and fixed smaller inconsistencies (ENT-3562)
- Validate Class Regex properly in Mission Portal Hosts tree (ENT-3340)
- Increased password limit to 100 characters (ENT-2767)
- Sync masterfiles-stage with core-contrib (ENT-3434)
- Removed extra column "host key" in report export (ENT-3102)
- Inventory Policy Release ID by default (CFE-2097)
- Fixed lastseen interval values in LastSeenHosts report (ENT-3320)
- Included Agent Execution Status report in rebase query replies (ENT-3246)
- Disable Design Center by default (ENT-3462)
- Added inventory API
- Speed up host tree loading (ENT-3474)
- Included time to pack reports in benchmarks (ENT-3323)
- Fixed multiple users to subscribing to same report
- Added Event API
- Ignore non numeric values in free disk space report (ENT-3305)
- Added Host count API and trend widget for dashboard (ENT-3484)
- Inventory UI now uses inventory API (ENT-2801)
- Increased cf-hub network timeout from 10 to 30 seconds (ENT-3153)
- Changed exit codes of cf-hub to be much more useful
  In short, when using --query, exit code will be number of failed
  host report collections, up to 100. 101+ are reserved for specific
  error conditions. (ENT-3829)
- Added an error summary when running cf-hub --query
- Removed count of updates installed from host info page
  Updates installed are only available for some platforms and only from the legacy
  package promise implementation. It is being removed to avoid making users think
  no patches are installed when the platform doesn't differentiate patch installs
  from base packages (ENT-3401)
- Query API response now properly informs of invalid requests (ENT-3226)
- New type of report was added to identify hosts likely using same identity
  (ENT-3550)
- Report Hosts never collected from was added to health diagnostics (ENT-3551)
- Windows 10 OS is now correctly detected for platform classes (ENT-3363)

**Packaging changes:**
- Optimised Windows version generation
- Use share/GUI as template when purging httpd/htdocs dir (ENT-3217)
- Removed obsolete options from PostgreSQL config (ENT-3656)
- Added cf_net.exe to msi packaging
- Removed package installation of cf-twin (CFE-2029)
- Removed unused sysconfig variable RUN_CF_HUB (CFE-2739)
- Run ldap migration script in postinstall.sh (ENT-3284)
- Ensured Enterprise Hub package upgrade aborts when backup fails (ENT-3336)
- Enabled LDAP support in PHP (ENT-3373)
- Run ldap post-install.sh after installation (ENT-3382)
- Set default memory_limit for php to 256M (ENT-3391)
- Upgraded using pg_upgrade instead of dump/restore (ENT-3398)
- Removed libphp5.so (ENT-3520)
- Removed libmcrypt dependency
- Updated PCRE from 8.40 to 8.42
- Updated rsync from 3.1.2 to 3.1.3
- Updated PostgreSQL from 9.6.2 to 10.4
- Updated git from 2.13.0 to 2.17.1
- Updated LMDB from 0.9.19 to 0.9.22
- Updated libxml2 from 2.9.4 to 2.9.8
- Updated PHP from 5.6.30 to 7.2.6
- Updated OpenSSL from 1.0.2k to 1.1.0h
- Updated CURL from 7.54.0 to 7.60.0
- Updated OpenLDAP from 2.4.44 to 2.4.46
- Updated Apache from 2.4.25 to 2.4.33
- Updated APR from 1.5.2 to 1.6.3
- Updated APR-util from 1.5.4 to 1.6.1

## 3.11.0
- Optimized Query API by removing subsequent count query for pagination
  (ENT-2829)
- cf-monitord: fix custom measurements of type counter
- Fixed saved report access by roles (ENT-3099)
- Add button for copy host link (ENT-3096)
- Logs from mission portal moved outside webroot folder (ENT-2758)
- Maintain sorting of columns in export inventory report (ENT-614)
- Can't export csv fix (ENT-3092)
- Make host links clickable (ENT-3094)
- Show changes reports for “today” by default (ENT-2840)
- Add global host search (ENT-3059)
- Add CoreOS to the default hosts tree (ENT-3135)
- Fixed bogus error messages output from cf-monitord with custom measurements
  promises (ENT-2595)
- Add possibility to save username with dots
- Fixed disapearing hosts after upgrade (ENT-3112)
- Enforce license expiry correctly (remove extra month) (ENT-2261)
- Fixed file descriptor leak in hub's cf-serverd with call-collected clients
  (ENT-3088)
- Stop service cfengine3 status from warning on multiple httpd processes
  (ENT-3123)
- Monitoring app in Mission Portal never loads (ENT-3232)
- Fixed: allow multiple users to subscribe to same report
- Categorization view sharing in the hosts app fixed (ENT-3110)
- Warn when attempting to delete missing *.diff file during serving rebase query by cf-serverd (ENT-3261)
- Clear inventory lists from braces and quotes (ENT-154)

**Packaging changes:**
- Create a tar.gz binary package for CoreOS or other systems
- Fix: Mission Portal availability on install without running policy
  (ENT-3035)
- Fixed inability to correctly manage cf-postgres service after
  upgrade (CFE-2545)
- Relocated Mission Portal application logs
  Mission Portals application logs have moved from
  /var/cfengine/httpd/htdocs/application/logs to
  /var/cfengine/httpd/logs/application (ENT-2758)
- Set default timezone for php to UTC (ENT-3131)
- Updated autoconf from 2.60 to 2.69
- Updated curl from 7.50.3 to 7.53.1
- Updated libiconv from 1.14 to 1.15
- Upgraded to LMDB 0.9.19
- Removed postgresql dependency on agents in our binary packages
  (ENT-3164)
- Updated libcurl to 7.54.1
- Removed libvirt dependency from our binary packages (ENT-3164)
- Updated lcov from 1.10 to 1.13
- Updated PCRE from 8.39 to 8.41
- Updated Apache from 2.4.25 to 2.4.27
- Updated Redis from 3.2.6 to 3.2.9
- Updated PostgreSQL from 9.6.1 to 9.6.3
- Updated PHP from 5.6.29 to 5.6.31
- Upgraded openldap from 2.4.44 to 2.4.45
- Updated Git from 2.10.2 to 2.13.3

## 3.10.0
- Upgraded CFEngine dependencies to the following versions:
  - PostgreSQL 9.6.0
  - Redis 3.2.4
  - PHP 5.6.26
  - Git 2.10.1
- Added: Inventory for system product name (model) (ENT-2780)
- Changed: Disable TCP and redis (ENT-2761)
- Changed: Rename duplicate bodies in ha_update.cf (ENT-2753)
- Added: Ensure appropriate permissions for SSL files (ENT-760)
- Fixed cf-serverd being launched under wrong account on Windows.
  (ENT-2755)
- Enterprise: Fix Postgres database migration from 3.8- to 3.9+.
  (ENT-2760)
- Hub package no longer depends on libltdl. (ENT-2714)
- Added: Enterprise appliaction log dir to rotation
- Changed: Session Cookies use HTTPOnly and secure attribtues (ENT-2781)
- Changed: re-enable hub process maintainance
- Changed: Disable RC4 Cipher for ssl in Mission Portal
- Changed: Reduce php info leak
- Changed: Reduce Enteprise webserver info
- Fixed errors of type "No file object exsists in path" on
  Windows.
- Canonify class names stored in class history log. (ENT-2821)
- Changed: Disable autocomplete for login
- Fixed a bug which incorrectly detected PostgreSQL running
  status when running "/etc/init.d/cfengine3 status".
- Optimized Query API by removing subsequent count query for
  pagination. (ENT-2829)

## 3.9.0
- Changed: Render Mission Portal httpd.conf with mustache
  (Jira ENT-2568)
- Changed: Switch to http redirect by default (Jira ENT-2071)
- Fixed exporting CSV reports through HTTPS. (Redmine #7267)
- Added: Bundle to generate a self signed cert for Mission Portal
- For call collect in Enterprise, default collect_window
  setting increased from 10 to 30 seconds for reliability reasons
  in large-scale environments.
- Upgraded CFEngine dependencies to the following versions:
  - Apache     2.4.20
  - Git        2.8.3
  - PHP        5.6.22
  - PostgreSQL 9.5.3
  - Redis      3.0.7
  - rsync      3.1.2
  (Jira ENT-2720)
- Fixed scheduled report not beeing emailed when report type is set to only contain CSV file type.
  (Redmine #3780, #7619)
- Introduced class json log. (Redmine #7951)
- Introduced new promise log logging. (Redmine #7887)
- Fixed broken call collect. (Redmine #7701)
- Fixed error logging to MP via HTTPS. (Redmine #7687)

## 3.8.2
        No Enterprise specific fixes for 3.8.2, see Community changelog.

## 3.8.1
Changes:
- Upgraded CFEngine Enterprise dependencies to the following versions:
  - OpenSSL   1.0.2e
  - PCRE      8.38
  - libxml2   2.9.3
  - OpenLDAP  2.4.43
  - Redis     3.0.6
  - PHP       5.6.17
  - libcurl   7.46.0
  - Git       2.6.5

## 3.8.0
Changes:
- Moved hub_log from /var/cfengine to /var/cfengine/log.
- Behavior changed: when running "cf-hub -q -H" manual
  report collection, policy is parsed before collecting, so there must be
  valid policy in inputs directory. (Redmine #7542)
- Introduced by field truncation for promise execution entries.
  (Redmine #7466)
- Moved promise_summary.log into /var/cfengine/log directory.

Bug fixes:
- CFEngine on Windows no longer truncates log messages if the
  program in question is killed halfway through.
- For call collect in Enterprise, default collect_window
  setting increased from 10 to 30 seconds for reliability reasons
  in large-scale environments.
- Fixed package not installing on Windows 2008 32-bit. (Redmine #7478)
- Fixed not being able to delete log files while CFEngine is running on
  Windows. (Redmine #7149)
- Fix: Typo in cf-hub error message
- Fixed resource restrictions of SQL API matching table names as substrings.
  (Redmine #7536)
- Removed error message from cf-serverd when not finding software inventory.
  E.g. "Failed to access current state for report: `software`".
- Fixed last agent run timestamp in Agents not reporting (health bar).
  (Redmine #7406)

## 3.7.2
Bug fixes:
- For call collect in Enterprise, default collect_window
  setting increased from 10 to 30 seconds for reliability reasons
  in large-scale environments.
- CFEngine on Windows no longer truncates log messages if the
  program in question is killed halfway through.
- Fix: Typo in cf-hub error message
- Removed error message from cf-serverd when not finding software inventory.
  E.g. "Failed to access current state for report: `software`".

## 3.7.1
Behavior changes:
- Behavior changed: when running "cf-hub -q -H" manual
  report collection, policy is parsed before collecting, so there must be
  valid policy in inputs directory. (Redmine #7542)

Bug fixes:
- Fixed resource restrictions of SQL API matching table names as substrings.
  (Redmine #7536)
- Add truncation for promise attribute sizes to prevent
  from ignoring to long reports. (Redmine: #7466)
- Fixed last agent run timestamp in Agents not reporting (health bar).
  (Redmine #7406)
- Fixed noise from internal policy to upgrade windows agents
  (Redmine #7456)
- Fixed package not installing on Windows 2008 32-bit. (Redmine #7478)

## 3.7.0
Mission Portal:
- Multiple dashboards
- Dashboard sharing
- `Changes` report type added
- `Changes` widget introduced
- Added more out-of-the-box inventory variables

Bug fixes:
- Fixed for health status in header occasionally not loading
- Fixed icons disappearing from host categorization dropdown after editing
- Process matching on Windows has been rewritten, which should make
  process promises work more reliable there. (Redmine #6977)
- Failure in output log cleanup on Windows has been fixed. (Redmine
  #7149)

API:
- Introduced Changes API
- Removed PromiseExecutionsLog (replaced with Changes API)
- Removed SoftwareUpdatesLog

## 3.6.6
Bug fixes:
- Ignore empty log messages while logging promise executions in cf-agent evaluation.
- Fixed Postgres CPU usage spikes.
- Fixed upgrate for monitoring.
- Fixed duplicate key value violates unique constraint "status_pkey" error.
- Reduce database size in high load hub by making vacuum strategy more aggressive.

## 3.6.5
Bug fixes:
- Fixed cleaning-up monitoring during upgrade.
- Removed unused bundles.lmdb to reduce agent I/O usage.
- Redesign classes and variables storage (for reporting) to reduce I/O usage.
- Improved API performance for DELETE requests on /api/host/:id resources.

Mission Portal:
- Small CSS changes
- Widgets & alerts view - UI changes
- Updated links to support portal

## 3.6.4
Bug fixes:
- Fixed "cfe_autorun_inventory_dmidecode" error message on Windows if
  Powershell is not installed.
- Fixed bogus failed promise, "cfe_internal...", as a result of indexing
  packages for the inventory screen. (Redmine #6865)

Mission Portal:
- LDAP settings UI improvements
- Unsaved SQL and Inventory Reports are preserved while refreshing/navigating in browser browser
- Help text: Added instructions to turn on Monitoring data
- Health bar dropdown labels and reports renamed

Changes:
- Introduced automatic rebase for the client if the client have not been successfully
  collected for defined period of time. Timeout is set by client_history_timeout
  attibute in hub body and if it is not set, it defaults to 6 hours.
  Note: During rebase all accumulated reports up till that event
        are ignored and not collected by the cf-hub.

## 3.6.3
Mission Portal:
- Added license information to header
- General UI cleanups and small bug fixes
- Optimization of Software Updates alert
- Inventory reports:
  - Made software filtering case insensitive
  - Updated help text
  - Performance improvements
- Alerts:
  - Bug fix for duplicate alerts in overview
  - Bug fixes for deleting alerts & widgets
- Settings:
  - LDAP search filter help text & validation

## 3.6.2
Changes:
- Monitoring magnified and monitoring yearly database schema have been redesigned
  to reduce database disk space usage over time.
- RBAC backend have been redesigned from dynamically generated tmp views
  to static global views that use session variables for passing context filters
  and host identifier. Filtering also switched from dynamically generated queries
  to Full Text Search.

 Mission Portal:
 - UI changes: redesigned alerts + conditions overview screen
 - Layout improvement of alert results view
 - Added navigation menu buttons to dashboard + alerts screens
 - High Availability status added to header bar
 - Custom notification script UI added to settings and alert editing
 - Added `Low disk space` alert + `System health` widget OOTB
 - Bug fixing/small UI improvements

## 3.6.1
Changes:
- `cf-key --install-license` installs hub-specific license key file "fqname-hostkey.dat"
  in $WORKDIR/licenses, where they can easily be managed centrally via a VCS
- hub-specific license file is searched in $WORKDIR/licenses before license.dat is searched
  in $WORKDIR, $WORKDIR/inputs and $WORKDIR/masterfiles
- Where appropriate, Enterprise API returns proper NULL json objects rather than literal
  "NULL" values

Mission Portal:
- Streamlined UI for inventory reporting
- Fixed username/role lookup failures if external authentication backend is case insensitive
- Reduced number of LDAP roundtrips
- Allowed filtering of reports by category
- Allowed reordering of widgets on dashboard
- UI for bulk-deleting decommissioned hosts from "health" menu
- Various behind-the-scene fixes and improvements to speed up UI and reporting

Platform support:
- Introduced Windows support into the CFEngine 3.6 series.

## 3.6.0
Mission Portal:
- UI and layout improvements and cleanups
- Dashboard and alerts introduced
- Inventory report type and view introduced
- Report categories introduced
- CFEngine health indicator added to UI with links to associated reports
- Host number indicator added to UI
- Inline help and help pop-ups added for new features
- Welcome tour pop-up introduced
- Host filter UI improvements - search host name, select/deselect all
- About CFEngine page - license and version information has moved to a dedicated page in settings
- Fixes for IE8 compatibility
- Added option in UI to allow logging in to Mission Portal over https
- Design Center sketch catalog redesign - sketches can now be filtered by category, tag, or search
- UI to reset git settings in Design Center

Hub:
- Removed --cache / -a command line option from cf-hub binary
- Removed --index / -i command line option from cf-hub binary
- Removed --maintain / -m command line option from cf-hub binary (Maintenance process have been implemented in the policy)
- Removed MongoDB Diagnostics
- Promise repaired/notkept log have been removed from report collection. It have been replaced by promise executions report.
- Total compliance report have been removed from report collection.
- Setuid report have been removed.
- Promise definitions report have been removed.
- Promise and bundle compliance reports have been removed. Their functionality have been replaced with promise executions report.
- Reporting database and report collection architecture have been redesigned to improve performance and scalability characteristics.
- MongoDB reporting database have been replaced with PostgreSQL 9.3
- Context, Variable, Software Installed, Software Patches and Promise Execution reports support history over time.
  History length is controlled per report type and can be configured in cfe_internal_hub_maintain bundle.
- Introduced new hub query type: `rebase` (`full` query aliases `rebase`) for re-downloading full state of the client in current moment.
  Rebase query result overwrites all non-historical entries about the host in the database.
- Included meta data contents to contexts and variables reports.

Enterprise Rest API:
- Rest interface for Design center
- Additional information returned for host (lastreport and firstseen)
- Rest API 2.2 (/rest API) have been removed.
- Enterprise API performance have been improved.
- SQL API table schema have been redesigned.
- Removed API cache.
- Pagination and sorting improvements.
- Introduced `hostIdentifier` setting to /api/settings.
- Fixes in LDAP support.
- Delete host API now additionally removes host from lastseen database as also removes host public key.

Bug fixes:
- Removed MongoDB
- cf-serverd for Windows now binds to both IPv4 and IPv6 by default, not just IPv6. (Redmine #3980)
- cf-agent now reports host packages installed and available by default. (Redmine #3257)
- Fixed incorrect file diff generation when a line had moved within a file, and
  certain other corner cases. (Redmine #5015)
- Windows fixes:
  - CFEngine now handles Windows newlines correctly within text files when editing or using
    the module protocol. Existing text files will keep their newline type (either LF or
    CRLF), whereas new files will get CRLF newlines. (Redmine #4733)
  - CFEngine will no longer display a blocking popup if it crashes.
  - CFEngine now reports uptime correctly on Windows.

Enterprise extensions:
- Removed promise_notkept_log_include, promise_notkept_log_exclude, promise_repaired_log_include, promise_repaired_log_exclude (syntax is valid but not functional)
- Removed classes_include, classes_exclude, variables_include, variables_exclude (syntax is valid but not functional)
- Introduced promise_handle_include, promise_handle_exclude attributes from report_data_select
- Introduced metatags_include, metatags_exclude attributes from report_data_select
- Deprecated export_zenoss attribute
- Introduced promise_execution.log containing outcome and information about all executed promises.
  It can be found under cfengine/state/ data format is CSV.
- Agent execution time have been included into benchmarks report.
- After disabling report_data_select filtering rule, include last known value in next packaged report.

## 3.5.3
Bug fixes:
- purge old data for promises with long promise handles (Redmine #3438)
- Fixed constraint violation in PromiseDefinitions table which resulted in error everytime this table was loaded (Redmine #3370)
- enable update of promise definitions database from policy
- Fixed cfengine3 init.d script to correctly detect debian systems with yum installed (Redmine #3589)

Mission Portal:
- Various layout and UI fixes
- Fixed editing of event trackers
- Speed up listing of hosts for promises not kept - maintain host context (Redmine #3474)
- Ability to manually add context filter in the SQL app (Redmine #3466)
- Host identifier settings simplified (Redmine #3101)

Packaging fixes:
- Correct php.ini path in the packaged httpd (Redmine #3445)
- Add missing mongodb tools in ubuntu/debian hub packages (Redmine #3444)
- Fixed manpath error for SLES (Redmine #3539)
- Fixed file permissions - some policy files had executable bit set (Redmine #3521)

## 3.5.2
Changes:
- MongoDB has been upgraded to version 2.2.4
- monitoring data has moved into a separate database
  See db-move-monitoring-to-cfmonitor.js script to migrate data

Bug Fixes:
- Fixed segfault of cf-serverd on HP-UX
- Do not to start a mongodb repair unnecessarily
- cf-hub -H now supports multiple hosts

Mission Portal:
- Reports can be published and shared between users
- Various UI improvements
- Optimizations in the report engine

## 3.5.1
Mission Portal:
- SQL queries can be shared between users
- Fixed timing issues for downloading large SQL reports
- Purge sketch data when no longer used by active sketches
- Uninstall sketches that have no activation
- Support for boolean, menu option and optional parameters in Design Center UI
- UI fixes to user and role management pages
- Delete navigation tree definitions of deleted uses
- Fixes to password reset
- General UI improvments
- Fixes for IE8 compatibility

Changes:
- Perform a database repair from init script if unclean shutdown of mongod is detected - Redmine #3035
- Data collection and cf-hub
    - Improved database connection handling during report collection by cf-hub.
- REST APIs support an optional disableCache flag; when set, the backend always hits the MongoDB - Redmine #2945

Bug Fixes:
- don't generate ERR message during maintenance if environments couldn't be queried, changed to INFO message
- Fixed usemodule on Windows (Redmine #1884)
- Fixed replica set detection (regression in 3.5) - Redmine #2806
- Set correct precision format when storing db diagnostics to avoid null-values
- Fixed possible division-by-zero bug in compliance meters (Redmine #2734)

## 3.5.0
New features:
- Mission Portal
    - Added Design Center UI to simplify sketch activation, including MP specific git settings to support version control of sketch configurations
    - re-focused apps support quick navigation
    - Added persisting host and policy context between apps
    - extended the SQL builder interface with more tables
        - Added FirstReportTimeStamp into Hosts table in SQL REST API.
          This time value represent fist report time after bootstrap,
          already bootstrapped agents will set this with first report after update.
        - Added regular expression support to SQL queries
        - HostContext filter support in SQL REST API.
    - Added global navigation trees which are only editable by admins, including the option to share trees with other users
- REST API extensions
  - New optional parameters for REST API were added: hostContextInclude and hostContextExclude (array type)
  - PromiseContext filter support in SQL REST API.
  - New optional parameter for REST API was added: promiseContext (input: all / user / system)
- Data collection and cf-hub
  - Added set and clear triggers for persistently disabling CFEngine components.
    eg. to disable cf-monitord, run cf-agent with "-Dset_persistent_disable_cf_monitord"
    to re-enable use: "-Dclear_persistent_disable_cf_monitord"
  - Host side report content filter for class, variable, promise log and monitoring reports.
    Controlled by report_data_select body in access promise.
  - Diagnostics logging and SQL REST API for MongoDB, report collection and maintenance process on the enterprise hub.
- Windows Powershell support. execresult(), returnszero() and commands promises now
  supports "powershell" as an option in addition to the "noshell" and "useshell" variants.
  "powershell" is also added as a hard class in order to test whether Powershell is available.

Changes:
- Mission Portal
  - new visual design
  - streamlined interactions for building new trees
  - trees are now loaded lazily
  - general clean-up to the tree controls
  - hosts in trees are no longer color coded
  - hosts are only classified as red, green or missing data
  - operating system tree is now loaded by default
  - SQL queries are now run by default after clicking their respective links, running a query is now primary action in the UI (#2393)
  - data and result sets can now by filtered based on navi-tree
  - logged-in user's name is visible again in the toolbar
  - removed beta apps
- Windows
  - Improved ACL handling on Windows, which led to some syntax changes. We now consistently
    use the term "default" to describe ACLs that can be inherited by child objects. These
    keywords have received new names:
      acl_directory_inherit -> acl_default
       specify_inherit_aces -> specify_default_aces
    The old keywords are deprecated, but still valid. In addition, a new keyword
    "acl_inherit" controls inheritance behavior on Windows. This feature does not exist on
    Unix platforms.
- Enterprise API
  - Export SQL results to sqlite3 database file
- Data Collection and cf-hub
  - cf-hub has got an option -q to query reports from the running agent.
    This option used to reside in cf-runagent, and has been moved to cf-hub.
  - Full and delta reports send only mon and sys variables as also hosts excluding policy
    server are reporting only subset of monitoring data.
    This can be changed using access promise in default cf_serverd.cf policy.
- Removed license checking on hosts.

Bugfixes:
- Mission Portal
  - promise finder now does string matching
  - assigning roles in user management now makes sense
  - report builder now has a "new query" button
  - blue hosts` lacking data history is indicated correctly now
  - CSS fixes
  - finders no longer load duplicate list items
  - Fix inconsistent behavior of black host status directly after install.
- Enterprise API
  - Fix some REST queries not working on replica secondaries (eg. the /rest/host/:id)
- Removed HTML output from Total Compliance report

## 3.0.x
- Removed unused options "[-t][-r][-u]" from cf-know

## 3.0.1
- $(sys.licenses_installtime) variable removed from "Enterprise Free"

## 3.0.0
- New Reporting Engine: A SQL interface to reports collected by hub.

We allow all standardised SQL SELECT constructs to query the SQL reports database, with the following additions:
- TIMESTAMP_UNIX() - seconds elapsed since 1970
- TIMESTAMP_UNIX_DAYS() - days elapsed since 1970
These are added to avoid use of non-portable SQL date/time functions.

Enterprise API:
- Read + write REST interface for
  - report querying(utilizes underlying reporting engine)
  - user management
  - can be used with REST API v1 in parallel
- Configurable hostnames(host/system identifier) in reports
- can take any of the sys variables(eg.$(sys.fqhost))
- When decommissioning (deleting a host) from the Mission Portal/Enterprise API,
  the public keys of the clients are also removed
- Ability to delete multiple hosts from the mission portal
- Improvements on the hub maintenance process
  less resource intensive and configurable
- New option for cf-hub added (-m) for Enterprise database maintenance
- Fixes on database connections problems
- If you were seeing "connection refused because too many open connections",
  in database log please consider upgrading
- Changed "nova>" to "enterprise>" in agent verbose output
- Please update email filters
- Removed internal CFE promises from reporting
- New classes enterprise, enterprise_X, enterprise_X_Y, enterprise_X_Y_Z
  on CFEngine Enterprise, to reflect the version running. New variable
  sys.enterprise_version that holds the CFEngine Enterprise version.
  This complements the Nova classes and the sys.nova_version variable,
  which will eventually be deprecated.
- Fixed file change report containing warning message as filename for new/deleted files
- File diff log (nova_diff.log) have been extended with promise handle name.
- Total compliance output in cf-agent verbose mode and promise_summary.log
  have been extended with user and cfengine internal compliance level.
- System variables are collected by hub in every delta query
- Fixed software reports showing "(never)" in the "Last seen" column
- Fixed "blue hosts" list being empty for clients that don't have class keys
- Sendmail is installed by default on the hub - required for emailing of reports
- 32-bit hub installations no longer supported
- Created a variable update_policy.mongodb_dir, for cases where MongoDB
  should not run out of /var/cfengine/state (could grow to tens of gigabytes).
- Removed commercial_customer class, as it was unused in internal policies.
  Please use enterprise_edition instead if you used this in your policies.
- New performance report events: DBPurgeHostsAll, DBMaintenance,
  DBMaintenanceTimestampsSingleHost, DBCacheCompliance, DBReportCollectAll.
- License verification is made more robust by not relying on the last-seen
  database anymore. This means you do not need to bootstrap a client to
  verify the license. See the cf-key --install-license option.

## 2.2.0
- More diagnostics on report collection from cf-hub. Logging more
  useful information in cf-hub -l, measuring total collection time
  in benchmarks report, under id "ReportCollectAll".
- Fixed issue where client would show as green in the Mission Portal when no
  data was received, e.g. due to access or license error at client.
  Now correctly shows as blue in these cases.
- Greatly reduced amount of connections from cf-hub
  to localhost mongodb. Now there is one connection per
  cf-hub run (max 50), before it was three per client.
- Software and variable report now contains end-node discovery time.
- Software and patches available/status reports contain maximum 5-minute old data,
  improved from 6 hours in last release. This will only apply to clients
  that are upgraded to 2.2.0.
- Software report query from Mission Portal is much faster on larger data-sets due
  to removal of autocomplete feature.
- Upgraded mongod from version 1.8.2 to 2.0.4, which increases
  efficiency on concurrency and reduces memory usage.
- New function hostswithclass() that generates a list of hosts in a given class
  on the hub.
- The bundled failsafe.cf policy now has trustkey=false to avoid IP spoofing
  attacks in default policy

## 2.1.0
- New interface with interactive graphs on Nova hub.
- User management on hub.
- Allowing TAB in file diff report. Better handling
  of large diffs and attempts to diff binaries.
- Support for adding notes to all hosts and reports.
- Support for policy staging environments.
- Nova reports can be exported to file and imported manually
  using cf-report -x and cf-report -i.
- Faster collection of monitoring (vitals) data due to
  new protocol and data structure.
- Long-term storage (one year) of diff and changes reports.
- The variables report got a last-seen column. Now variables
  are stored in the hub for a longer time like classes,
  and not overwritten on every update.
- The report of reports-promises are shown in the promise repaired log
  in the Mission Portal.
- New option cf-hub --cache, recreates the cache data needed
  by the web interface.
- Only showing the last seen host name and ip address when
  listing hosts and on the host page.
- Reliability improvements, especially when querying
  the variables report.

## 2.0.2
- Much faster report querying.
- Allows to specify age interval when querying promise not
  kept and repaired.
- Promiser conflict identifcation.
- Built with CFEngine Community Edition 3.1.4.

## 2.0.1
- Fixed promise query of not kept/promise repaired logs.

## 1.2.0:
- Windows Event Logs include output_prefix if set, and which component
  reported the event. The verbosity of event logs have been reduced
  by not including promise kept and repaired events, this can now be
  tuned with action.log_level.
- Take out network communications from total state calculation,
  as it gets counted twice.

## 1.1.2:
- Encryption problems fixed in Community Edition.
- Built with CFEngine Community Edition 3.0.4p3.

## 1.1.0:
- Regular expressions in file paths supported on Windows by using
  forward slash as path separator.
- CPU utilization report on Windows.
  Users logged in report on Windows.
- On the Windows cf-serverd, requests for /var/cfengine are
  translated to $(sys.workdir)\Cfengine, and path separators are
  automatically adjusted ("/" becomes "\"). This yields support for
  more platform-independent promises and allows for automatic
  copying of reports from Windows clients to the policy server.
- Scale on graphs in the Knowledge Map, and different background
  color gives more readability.
- Special functions added for accessing remote classes for distributed cooperation.

## 1.0.0:
- Reports added to cf-report for compliance, setuid, file_changes etc.
  Added csv format also
- Automating topic map integration of policy, with impact analysis
  using promisee and builds_on promises.
- Literal string lookup in server.
- Database SQL and registry functions added. Verification and sanity
  checking of SQL database table structure. Create and destroy
  databases convergently.
- Access control list support for Linux.
- Powerful and lightweight promises for Customizable monitoring and
  system discovery promises added to cf-monitord.
- Longterm memory for 3 year trend analysis.
