<?php

require_once APPPATH . '/libraries/Cf_REST_Controller.php';

class FavouriteReports extends Cf_REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->username = $this->session->userdata('username');
        $this->load->model('favourite_reports_model');
    }

    public function report_get()
    {
        $data = $this->favourite_reports_model->list($this->username);
        respond_ok(json_encode($data));
    }

    public function report_post($reportId)
    {
        $id = $this->favourite_reports_model->add($this->username, intval($reportId));
        respond_created(json_encode(['id' => $id]));
    }

    public function report_delete($reportId)
    {
        $this->favourite_reports_model->delete($this->username, intval($reportId));
        respond_ok();
    }
}
