Policy file browser API allows to read file system to get policy files tree and get policy file contents. Only admins have access to this API.

## Get Files

Get files tree.

**URI:** https://hub.cfengine.com/api/policy/files

**Method:** GET

**Response parameters:**

* **name** *(string)*
    Directory or file name
* **path** *(object)*
    Absolute and relative paths.
* **children** *(array)*
    Children elements.
* **hash** *(string)*
    Policy file hash. Only files have hash property.


**Example response:**


```
[
  {
    "name": "cfe_internal",
    "path": {
      "absolute": "/opt/cfengine/analyzer/policy/masterfiles/cfe_internal",
      "relative": "/cfe_internal"
    },
    "children": [
      {
        "name": "core",
        "path": {
          "absolute": "/opt/cfengine/analyzer/policy/masterfiles/cfe_internal/core",
          "relative": "/cfe_internal/core"
        },
        "children": [
          {
            "name": "deprecated",
            "path": {
              "absolute": "/opt/cfengine/analyzer/policy/masterfiles/cfe_internal/core/deprecated",
              "relative": "/cfe_internal/core/deprecated"
            },
            "children": [
              {
                "name": "cfengine_processes.cf",
                "path": {
                  "absolute": "/opt/cfengine/analyzer/policy/masterfiles/cfe_internal/core/deprecated/cfengine_processes.cf",
                  "relative": "/cfe_internal/core/deprecated/cfengine_processes.cf"
                },
                "hash": "63fa1e07c06ad0b11d5b6386250630fe925e89a8567429230a5aa6e5715a905f"
              }
            ]
          },
          {
            "name": "watchdog",
            "path": {
              "absolute": "/opt/cfengine/analyzer/policy/masterfiles/cfe_internal/core/watchdog",
              "relative": "/cfe_internal/core/watchdog"
            },
            "children": [
              {
                "name": "templates",
                "path": {
                  "absolute": "/opt/cfengine/analyzer/policy/masterfiles/cfe_internal/core/watchdog/templates",
                  "relative": "/cfe_internal/core/watchdog/templates"
                },
                "children": [
                  {
                    "name": "watchdog.mustache",
                    "path": {
                      "absolute": "/opt/cfengine/analyzer/policy/masterfiles/cfe_internal/core/watchdog/templates/watchdog.mustache",
                      "relative": "/cfe_internal/core/watchdog/templates/watchdog.mustache"
                    },
                    "hash": "cd7acbfbb3aa311ec6b108d566183b7d4e27c2a242a359f1d05e65d611f3f171"
                  }
                ]
              },
              {
                "name": "watchdog.cf",
                "path": {
                  "absolute": "/opt/cfengine/analyzer/policy/masterfiles/cfe_internal/core/watchdog/watchdog.cf",
                  "relative": "/cfe_internal/core/watchdog/watchdog.cf"
                },
                "hash": "f89f2ef15c540c68d5133307152493a7e3271a9380dc3982980fa61728b9b3ed"
              }
            ]
          },
          {
            "name": "host_info_report.cf",
            "path": {
              "absolute": "/opt/cfengine/analyzer/policy/masterfiles/cfe_internal/core/host_info_report.cf",
              "relative": "/cfe_internal/core/host_info_report.cf"
            },
            "hash": "fb1c3f026553b4b03e41b3686f67fc62518a418792e6da07dcdeef8917754054"
          },
          {
            "name": "limit_robot_agents.cf",
            "path": {
              "absolute": "/opt/cfengine/analyzer/policy/masterfiles/cfe_internal/core/limit_robot_agents.cf",
              "relative": "/cfe_internal/core/limit_robot_agents.cf"
            },
            "hash": "696d24ade7d360f3ed7596686daa556bcc8359e5ef12ecdfe3183895c898237e"
          },
          {
            "name": "log_rotation.cf",
            "path": {
              "absolute": "/opt/cfengine/analyzer/policy/masterfiles/cfe_internal/core/log_rotation.cf",
              "relative": "/cfe_internal/core/log_rotation.cf"
            },
            "hash": "1d80835c814fd81b878d1086b0005a98de8ea21f901a62e4263df62958d4feab"
          },
          {
            "name": "main.cf",
            "path": {
              "absolute": "/opt/cfengine/analyzer/policy/masterfiles/cfe_internal/core/main.cf",
              "relative": "/cfe_internal/core/main.cf"
            },
            "hash": "c7ee2c5e3d85b5b2f4ece190d099992289b785d71d97ed0b04ce91214a5808c5"
          }
        ]
      }
    ]
  },
  {
    "name": "promises.cf",
    "path": {
      "absolute": "/opt/cfengine/analyzer/policy/masterfiles/promises.cf",
      "relative": "/promises.cf"
    },
    "hash": "502c2431d82a5a6c4c73f0e70ae13dac23f7f1f5cc0fbe438219483045e48fda"
  },
  {
    "name": "standalone_self_upgrade.cf",
    "path": {
      "absolute": "/opt/cfengine/analyzer/policy/masterfiles/standalone_self_upgrade.cf",
      "relative": "/standalone_self_upgrade.cf"
    },
    "hash": "1c13761728476379edf649f6c2a8608b97b3c3b1e4d484d48c4116877481cbee"
  },
  {
    "name": "update.cf",
    "path": {
      "absolute": "/opt/cfengine/analyzer/policy/masterfiles/update.cf",
      "relative": "/update.cf"
    },
    "hash": "51c2f5514920cd3189e0e9a10f9e5439657745980e53f707eef9c3f0703b8167"
  }
]
```

## Policy file contents

**URI:** https://hub.cfengine.com/api/policy/contents

**Method:** GET

Shows file contents

**Parameters:**

* **path** *(string)*
    Relative path to the file.

**CURL request example**
```
curl -k --user admin:admin -X  GET  https://hub.cfengine.com/api/policy/contents?path=update.cf
```

**Example response:**

```
###############################################################################
#
#   update.cf - Basic Update Policy
#
###############################################################################

body common control
{
      bundlesequence => {
                          "update_def",
                          "u_cfengine_enterprise",
                          @(u_cfengine_enterprise.def),
                          "cfe_internal_dc_workflow",
                          "cfe_internal_update_policy",
                          "cfengine_internal_standalone_self_upgrade",
                          "cfe_internal_update_processes",
                          @(update_def.bundlesequence_end), # Define control_common_update_bundlesequnce_end via augments
      };

      version => "update.cf $(update_def.current_version)";

      inputs => {
                  "cfe_internal/update/lib.cf",
                  "cfe_internal/update/systemd_units.cf",
                  @(cfengine_update_controls.update_def_inputs),
                  "cfe_internal/update/cfe_internal_dc_workflow.cf",
                  "cfe_internal/update/cfe_internal_update_from_repository.cf",
                  "cfe_internal/update/update_policy.cf",
                  "cfe_internal/update/update_processes.cf",
                  @(update_def.augments_inputs)
      };

    any::
        ignore_missing_bundles => "$(update_def.control_common_ignore_missing_bundles)";
        ignore_missing_inputs => "$(update_def.control_common_ignore_missing_inputs)";

}

#############################################################################
bundle common cfengine_update_controls
{
  vars:
       "update_def_inputs"
        slist => {
                   "controls/update_def.cf",
                   "controls/update_def_inputs.cf",
                 };

  reports:
    DEBUG|DEBUG_cfengine_update_controls::
      "DEBUG $(this.bundle): update def inputs='$(update_def_inputs)'";
}

bundle agent cfengine_internal_standalone_self_upgrade
# @brief Manage the version of CFEngine that is currently installed. This policy
# executes a stand alone policy as a sub agent. If systemd is found we assume
# that it is necessary to escape the current unit via systemd-run.
{
  vars:

      "exec_prefix"
        string => ifelse( isexecutable("/bin/systemd-run"), "/bin/systemd-run --unit=cfengine-upgrade --scope ", # trailing space in commands important
                          isexecutable( "/usr/bin/systemd-run" ), "/usr/bin/systemd-run --unit=cfengine-upgrade --scope ",
                          "");

      "desired_pkg_data_path" -> { "ENT-3592" }
        string => "$(sys.statedir)/MPF/desired-cfengine-package-version.json";

      "desired_pkg_data" -> { "ENT-3592" }
        data => readjson( $(desired_pkg_data_path), inf ),
        if => fileexists( $(desired_pkg_data_path) );

  classes:
      # If we are running the version desired by the self upgrade policy
      "at_desired_version" -> { "ENT-3592" }
        expression => strcmp( "$(desired_pkg_data[version])", "$(sys.cf_version)"  );

      # If we are running the version explicitly defined by the user
      "at_desired_version" -> { "ENT-3592" }
        expression => strcmp( "$(def.cfengine_software_pkg_version)", "$(sys.cf_version)" );

  commands:

    trigger_upgrade.!at_desired_version::

      "$(exec_prefix)$(sys.cf_agent)"
      handle => "standalone_self_upgrade",
      args => '--inform --timestamp --file "$(this.promise_dirname)$(const.dirsep)standalone_self_upgrade.cf" --define trigger_upgrade,update_cf_initiated';

  reports:

    inform_mode|verbose_mode|DEBUG|DEBUG_cfengine_internal_standalone_self_upgrade::
      "Skipped self upgrade because we are running the desired version $(sys.cf_version)" -> { "ENT-3592" }
        if => "at_desired_version";

}

body agent control
{
      ifelapsed => "1";
      skipidentify => "true";
}

#############################################################################

body classes u_kept_successful_command
# @brief Set command to "kept" instead of "repaired" if it returns 0
{
      kept_returncodes => { "0" };
      failed_returncodes => { "1" };
}

```