<?php

class CF_Widget
{
    public $id;
    public $username;
    public $name;
    public $type;
    public $payload;
    public $alerts; // combinations of rules, hosts, notifications | array
    public $ordering; // combinations of rules, hosts, notifications | array

    //var $runtime; // do not use now

    public function __construct($params = [])
    {
        $this->id = isset($params['id']) ? $params['id'] : null;
        $this->username = isset($params['username']) ? $params['username'] : null;
        $this->name = isset($params['name']) ? $params['name'] : null;
        $this->type = isset($params['type']) ? $params['type'] : null;
        $this->ordering = !empty($params['ordering']) ? $params['ordering'] : null;
        $this->payload = !empty($params['payload']) ? $params['payload'] : null;

        $this->alerts = !empty($params['alerts']) ? explode(',', $params['alerts']) : [];
    }

    public function getId()
    {
        return $this->id;
    }

    public function getUsername()
    {
        return $this->username;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getPayload()
    {
        return $this->payload;
    }

    public function getType()
    {
        return $this->type;
    }

    public function getAlerts()
    {
        return $this->alerts;
    }

    public function getOrdering()
    {
        return $this->ordering;
    }
}
