<?php

class CfAutocomplete
{
    public function __construct(
        private \PDO $dbConnection
    ) {
    }

    public function getClasses(string $query): array
    {
        $stmt = $this->dbConnection->prepare(
            'SELECT contextname as class 
            FROM __contexts 
            WHERE contextname ILIKE ? 
            ORDER BY contextname ASC'
        );
        $stmt->execute(["%{$query}%"]);
        return $stmt->fetchAll(\PDO::FETCH_COLUMN);
    }

    public function getVariables(string $query): array
    {
        $stmt = $this->dbConnection->prepare(
            'SELECT CONCAT(namespace, \':\', bundle, \'.\', variablename) as full_definition,
            variablename as name
            FROM __variables WHERE variablename ILIKE ?
            ORDER BY variablename ASC'
        );
        $stmt->execute(["%{$query}%"]);
        $variables = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        return array_reduce($variables, function ($acc, $item) {
            $acc[$item['full_definition']] = $item['name'];
            return $acc;
        }, []);
    }

    public function getInventoryAttributes(string $query): array
    {
        $stmt = $this->dbConnection->prepare(
            'SELECT attribute_name
            FROM variables_dictionary 
            WHERE attribute_name ILIKE ? 
            ORDER BY attribute_name ASC'
        );
        $stmt->execute(["%{$query}%"]);
        return $stmt->fetchAll(\PDO::FETCH_COLUMN);
    }
}
