<?php

/**
 * Class ExportBuilderFactory
 */
class ExportDataFactory
{
    public static function createExporter(string $type): ExportDataInterface
    {
        $class = ucfirst($type) . 'Exporter';
        $file = __DIR__ . '/implementations/' . $class . '.php';
        if (file_exists($file) && (include_once $file)) {
            $exporter = new $class();
            return $exporter;
        } else {
            throw new Exception('Class ' . $class . ' not found.');
        }
    }
}
