<div ng-app="dataTransferApp" id="ng-app">
    <div class="left-column">
        <?php include(APPPATH . 'views/appsetting/settingsSideBar.php'); ?>
    </div>
    <div class="right-column">
        <div ng-controller="dataTransferController">
            <div class="pageTitle">
                <h1>
                    <span>Export / Import</span>
                </h1>
            </div>

            <ul class="nav nav-tabs" id="tabs">
                <li class="active"><a href="#export">Export</a></li>
                <li><a href="#import">Import</a></li>
            </ul>

            <div class="tab-content">
                <div class="tab-pane active" id="export">
                    <div class="contentWrapper">
                        <h2>Select items to export</h2>
                        <hr/>
                        <ul>
                            <li ng-repeat="(key, value) in exportCategories track by $index"
                                ng-if="value.hasOwnProperty('name')">
                                <label><input type="checkbox" ng-model="exportObjects[value.id]"/> {{value.name}}</label>
                            </li>
                        </ul>
                        <a class="select-all-export" ng-click="selectAllExportItems()">Select all</a>
                        <hr/>
                        <div class="control-group">
                            <label>
                                <input type="checkbox" ng-model="exportOnlyUserItems" name="exportOnlyUsersItems">
                                Export only your items
                            </label>
                        </div>
                        <div class="control-group" ng-if="showEncryptionKeyField.export">

                            <label class="control-label" for="host">Encryption key</label>

                            <div class="controls">
                                <textarea id="encryptionKey" name="encryptionKey" ng-model="encryptionKey.export"
                                          class="input-xlarge"></textarea>
                                <p class="help-block">We encrypt sensitive data. Please save this key to be able to import
                                    the data.</p>
                                <button class="btn btn-default btn-small" ng-click="generateEncryptionKey()">generate new
                                    key
                                </button>
                            </div>
                        </div>
                        <hr/>
                        <button class="btn btn-primary btn-large" ng-click="export()">Export</button>

                    </div>
                </div>
                <div class="tab-pane" id="import">
                    <div class="controls level-text">
                        <p>Upload your import file</p>
                        <label class="btn btn-default" for="file-selector">
                            <input id="file-selector" import-uploader on-file-selected="onFileSelected(file)"
                                   type="file" accept=".phar" style="display:none"/>
                            Browse
                        </label>
                        <span class='label label-info' id="upload-file-info">{{seletedFile.name}}</span>
                    </div>

                    <div ng-hide="dataToImport == false">
                        <hr/>
                        <h3>To be imported:</h3>
                        <ul>
                            <li ng-repeat="(key, value) in exportCategories track by $index"
                                ng-if="value.hasOwnProperty('name') && dataToImport.hasOwnProperty(value.id)">
                                <span>{{value.name}}: {{dataToImport[value.id]}}</span>
                            </li>
                        </ul>
                    </div>
                    <div>
                    </div>

                    <div ng-show="dataToImport" class="margin-bottom">
                        <hr/>
                        <h4>Merge conflict resolution:</h4>
                        <div>
                            <label>
                                <input checked="checked" type="radio" ng-checked="skipDuplicates==1" ng-model="skipDuplicates" value="1"
                                       name="duplicate_action">
                                Keep all
                            </label>
                        </div>
                        <div>
                            <label>
                                <input type="radio" name="duplicate_action" ng-checked="skipDuplicates==0" ng-model="skipDuplicates" value="0">
                                Overwrite all
                            </label>
                        </div>
                        <div class="control-group" ng-if="showEncryptionKeyField.import">
                            <hr/>
                            <label class="control-label" for="host">Encryption key</label>

                            <div class="controls">
                                <textarea id="encryptionKey" name="encryptionKey" ng-model="encryptionKey.import"
                                          class="input-xlarge">{{importEncryptionKey}}</textarea>
                            </div>
                        </div>
                        <hr/>
                        <button class="btn btn-primary btn-large" ng-click="import()">Import</button>
                        <button class="btn btn-default btn-large" ng-click="cancelImport()">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
