<?php

class SettingsVCSExporter extends BaseDataExporter
{
    private $vcsConfig = '/opt/cfengine/dc-scripts/params.sh';
    private $vcsPrivateKey = '/opt/cfengine/userworkdir/admin/.ssh/id_rsa.pvt';

    public function isOnlyForAdmin(): bool
    {
        return true;
    }

    public function getData(): array
    {
        $data = [];
        if (file_exists($this->vcsConfig)) {
            $data['configPath'] = '/vcs/params.sh';
            $content = file_get_contents($this->vcsConfig);
            $encryptedContent = $this->ci->cf_encrypt->encryptByKey($content, $this->encryptionKey);
            $this->phar->addFromString($data['configPath'], $encryptedContent);
        }

        if ($this->vcsPrivateKey && file_exists($this->vcsPrivateKey)) {
            $data['keyPath'] = '/vcs/id_rsa.pvt';
            $content = file_get_contents($this->vcsPrivateKey);
            $encryptedContent = $this->ci->cf_encrypt->encryptByKey($content, $this->encryptionKey);
            $this->phar->addFromString($data['keyPath'], $encryptedContent);
        }

        return ['data' => json_encode($data), 'info' => sizeof($data) == 0 ? 'no' : 'yes'];
    }
}
