<?php

/**
 * Class Data_transfer
 */
class Data_transfer extends Cf_Controller
{
    /**
     * Data_transfer constructor.
     */
    public function __construct()
    {
        parent::__construct();
        setCurrentApplication('data_transfer');
    }

    /**
     * @rbacName View data transfer page
     * @rbacGroup Data transfer
     * @rbacAlias data_transfer.index
     * @rbacAllowedByDefault
     */
    public function index()
    {
        $requiredcss = [['../../../themes/default/css/angularjs-ui/angular-ui.css']];

        $this->carabiner->css($requiredcss);

        $bundles = [['dist/jquery-scripts.bundle.js'], ['dist/angular-base.bundle.js']];

        $requiredjs = [
            ['../themes/default/bootstrap/compiled/js/bootstrap.js'],
            ['data-transfer.jquery.js'],
            ['dataTransfer/app.js'],
            ['dataTransfer/controllers/dataTransferController.js'],
            ['dataTransfer/services/dataTransferService.js'],
            ['dataTransfer/directives/importUploader.js'],
        ];

        $this->carabiner->js($bundles, $bundles, false, false);
        $this->carabiner->js($requiredjs, $requiredjs, true, false);

        $data = ['title' => 'Export / Import - Mission Portal'];

        $this->template->load('template', 'data_transfer/index', $data);
    }

    /**
     * @param $partial
     */
    public function partials($partial)
    {
        $view = 'partials/' . $partial . '.php';
        $this->load->view($view);
    }
}
