<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
| 	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['scaffolding_trigger'] = 'scaffolding';
|
| This route lets you set a "secret" word that will trigger the
| scaffolding feature for added security. Note: Scaffolding must be
| enabled in the controller in which you intend to use it.   The reserved
| routes must come before any wildcard or regular expression routes.
|
*/
if (CLI === false) {
    $route['default_controller'] = 'welcome';
}

$route['scaffolding_trigger'] = '';
$route['welcome/bundle/(:any)'] = '/bundle/$1';

$route['404_override'] = 'error404/index';

$route['reports/open_rule_report/(.*+)'] = 'advancedreports/open_rule_report/$1';
$route['reports/complianceReport/(.*+)'] = 'advancedreports/complianceReport/$1';
$route['reports'] = 'advancedreports';
$route['reports/(.*)'] = 'advancedreports';
$route['hosts/(.*)'] = 'engineering/index/$1';
$route['hub-management'] = 'hub_management';

// Dashboard routes with dashboard ID
$route['dashboard/(\d+)/alerts/(.*)'] = 'dashboard';
$route['dashboard/(\d+)/eventlog'] = 'dashboard';
$route['dashboard/(\d+)/conditions/(.*)'] = 'dashboard';
$route['dashboard/(\d+)'] = 'dashboard';

// Dashboard routes without ID
$route['dashboard/alerts/(.*)'] = 'dashboard';
$route['dashboard/eventlog'] = 'dashboard';
$route['dashboard/conditions/(.*)'] = 'dashboard';

$route['hosts'] = 'engineering';

$route['measurements'] = 'monitoring';

$route['policy-analyzer'] = 'policy/analyzer';

// Settings routes
$route['settings/user-management'] = 'auth/admin_page';
$route['settings/user-management/(.*)'] = 'auth/admin_page/$1';
$route['settings/active-tokens'] = 'settings/online_users';
$route['settings/preferences'] = 'settings/manage';
$route['settings/host-identifier'] = 'settings/systemidentifier';
$route['settings/notification-scripts'] = 'settings/notification_scripts';
$route['settings/notification-scripts/(.*)'] = 'settings/notification_scripts/$1';
$route['settings/notification-scripts-update'] = 'settings/notification_scripts_update';
$route['settings/notification-scripts-update/(.*)'] = 'settings/notification_scripts_update/$1';
$route['settings/notification-scripts-delete/(.*)'] = 'settings/notification_scripts_delete/$1';
$route['settings/authentication'] = 'settings/ldap_api_settings';
$route['settings/export-import'] = 'data_transfer';
$route['settings/rbac'] = 'rbac';
$route['settings/rbac/(.*)'] = 'rbac/$1';
$route['settings/customization'] = 'customization';

// Build routes. All requests to /build will be served as build_app/build/index controller which starts JS framework
$route['build'] = 'build_app/build';
$route['build/(.*)'] = 'build_app/build';

// Host groups application routes
$route['groups'] = 'groups_app/groups';
$route['groups/(.*)'] = 'groups_app/groups';

// Auth routes
$route['auth/forgot-password'] = 'login/forgot_password';
$route['auth/reset-password/confirm'] = 'login/reset_password';
$route['auth/reset-password/change'] = 'login/change_password_by_reset_token';
$route['auth/reset-password/invalidate'] = 'login/reset_password_invalidate';

// Audit logs application routes
$route['audit-log'] = 'auditlog';
$route['audit-log/(.*)'] = 'auditlog';
/* End of file routes.php */
/* Location: ./system/application/config/routes.php */
