import React from 'react';
import { createRoot } from 'react-dom/client';
import { Provider } from 'react-redux';

import createCache from '@emotion/cache';
import { CacheProvider } from '@emotion/react';
import { LocalizationProvider } from '@mui/x-date-pickers';
import { AdapterDayjs } from '@mui/x-date-pickers/AdapterDayjs';

import { store } from '../components/AiAgent/store';

import AiAgent from '../components/AiAgent';
import { ThemeListener } from '../components/ThemeListener/ThemeListener';
import '../styles.scss';

const root = createRoot(document.getElementById('aiagent-root') as HTMLElement);
const cache = createCache({ key: 'mui', prepend: true });

root.render(
  <React.StrictMode>
    <Provider store={store}>
      <CacheProvider value={cache}>
        <LocalizationProvider dateAdapter={AdapterDayjs}>
          <ThemeListener>
            <AiAgent />
          </ThemeListener>
        </LocalizationProvider>
      </CacheProvider>
    </Provider>
  </React.StrictMode>
);
